"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestRunsTable = exports.MobileRowDetails = exports.LAST_10_TEST_RUNS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _view_document = require("../../common/components/view_document");
var _expand_row = require("../../test_now_mode/simple/ping_list/columns/expand_row");
var _use_ping_expanded = require("../../test_now_mode/simple/ping_list/use_ping_expanded");
var _screenshot_size = require("../../common/screenshot/screenshot_size");
var _errors_list = require("../monitor_errors/errors_list");
var _test_runs_table_header = require("./test_runs_table_header");
var _constants = require("../../../../../../common/constants");
var _test_details_link = require("../../common/links/test_details_link");
var _runtime_types = require("../../../../../../common/runtime_types");
var _test_time_formats = require("../../../utils/monitor_test_result/test_time_formats");
var _sort_pings = require("../../../utils/monitor_test_result/sort_pings");
var _state = require("../../../state");
var _status_badge = require("../../common/monitor_test_result/status_badge");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var _use_selected_location = require("../hooks/use_selected_location");
var _use_monitor_pings = require("../hooks/use_monitor_pings");
var _journey_last_screenshot = require("../../common/screenshot/journey_last_screenshot");
var _contexts = require("../../../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_summary/test_runs_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TestRunsTable = ({
  paginable = true,
  from,
  to,
  showViewHistoryButton = true
}) => {
  var _pingsError$body;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const [page, setPage] = (0, _react.useState)({
    index: 0,
    size: 10
  });
  const [sortField, setSortField] = (0, _react.useState)('timestamp');
  const [sortDirection, setSortDirection] = (0, _react.useState)('desc');
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    pings,
    total,
    loading: pingsLoading
  } = (0, _use_monitor_pings.useMonitorPings)({
    from,
    to,
    lastRefresh,
    pageSize: page.size,
    pageIndex: page.index
  });
  const sortedPings = (0, _react.useMemo)(() => {
    return (0, _sort_pings.sortPings)(pings, sortField, sortDirection);
  }, [pings, sortField, sortDirection]);
  const pingsError = (0, _reactRedux.useSelector)(_state.selectPingsError);
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const isTabletOrGreater = (0, _eui.useIsWithinMinBreakpoint)('s');
  const isBrowserMonitor = (monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.MONITOR_TYPE]) === _runtime_types.MonitorTypeEnum.BROWSER;
  const {
    expandedRows,
    setExpandedRows
  } = (0, _use_ping_expanded.useExpandedPingList)(pings);
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const handleTableChange = ({
    page: newPage,
    sort
  }) => {
    if (newPage !== undefined) {
      setPage(newPage);
    }
    if (sort !== undefined) {
      setSortField(sort.field);
      setSortDirection(sort.direction);
    }
  };
  const columns = [...(isBrowserMonitor ? [{
    align: 'left',
    field: 'timestamp',
    name: SCREENSHOT_LABEL,
    render: (timestamp, item) => /*#__PURE__*/_react.default.createElement(_journey_last_screenshot.JourneyLastScreenshot, {
      checkGroupId: item.monitor.check_group,
      size: [100, 64],
      timestamp: timestamp,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 15
      }
    }),
    mobileOptions: {
      header: false,
      render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        css: {
          width: '100%',
          height: '100%'
        },
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_journey_last_screenshot.JourneyLastScreenshot, {
        checkGroupId: item.monitor.check_group,
        size: _screenshot_size.THUMBNAIL_SCREENSHOT_SIZE_MOBILE,
        timestamp: item['@timestamp'],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 19
        }
      }))
    }
  }] : []), {
    align: 'left',
    valign: 'middle',
    field: 'timestamp',
    name: '@timestamp',
    sortable: true,
    render: (timestamp, ping) => /*#__PURE__*/_react.default.createElement(_test_details_link.TestDetailsLink, {
      isBrowserMonitor: isBrowserMonitor,
      timestamp: timestamp,
      ping: ping,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }),
    mobileOptions: {
      header: false,
      render: item => /*#__PURE__*/_react.default.createElement(MobileRowDetails, {
        ping: item,
        isBrowserMonitor: isBrowserMonitor,
        basePath: basePath,
        locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 11
        }
      })
    }
  }, {
    align: 'left',
    valign: 'middle',
    field: 'monitor.status',
    name: RESULT_LABEL,
    sortable: true,
    render: (status, test) => {
      var _test$summary$attempt, _test$summary, _test$summary$final_a, _test$summary2;
      const attemptNo = (_test$summary$attempt = (_test$summary = test.summary) === null || _test$summary === void 0 ? void 0 : _test$summary.attempt) !== null && _test$summary$attempt !== void 0 ? _test$summary$attempt : 1;
      const isFinalAttempt = (_test$summary$final_a = (_test$summary2 = test.summary) === null || _test$summary2 === void 0 ? void 0 : _test$summary2.final_attempt) !== null && _test$summary$final_a !== void 0 ? _test$summary$final_a : false;
      if (!isFinalAttempt || attemptNo === 1) {
        return /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
          status: (0, _status_badge.parseBadgeStatus)(status !== null && status !== void 0 ? status : 'skipped'),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 179,
            columnNumber: 18
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
        status: (0, _status_badge.parseBadgeStatus)(status !== null && status !== void 0 ? status : 'skipped'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        "data-test-subj": "isRetestIcon",
        type: "refresh",
        content: FINAL_ATTEMPT_LABEL,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 15
        }
      })));
    },
    mobileOptions: {
      show: false
    }
  }, ...(!isBrowserMonitor ? [{
    align: 'left',
    field: 'monitor.ip',
    sortable: true,
    name: _i18n.i18n.translate('xpack.synthetics.pingList.ipAddressColumnLabel', {
      defaultMessage: 'IP'
    })
  }] : []), {
    align: 'left',
    field: 'error.message',
    name: MESSAGE_LABEL,
    textOnly: true,
    css: (0, _common.css)`
        max-width: 500px;
      `,
    render: errorMessage => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 9
      }
    }, (errorMessage === null || errorMessage === void 0 ? void 0 : errorMessage.length) > 0 ? errorMessage : '-'),
    mobileOptions: {
      show: false
    }
  }, {
    align: 'right',
    valign: 'middle',
    field: 'monitor.duration.us',
    name: DURATION_LABEL,
    sortable: true,
    render: durationUs => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 39
      }
    }, (0, _test_time_formats.formatTestDuration)(durationUs)),
    mobileOptions: {
      show: false
    }
  }, {
    align: 'right',
    actions: [{
      'data-test-subj': 'syntheticsViewPingDocument',
      isPrimary: true,
      name: _view_document.INSPECT_DOCUMENT,
      description: _view_document.INSPECT_DOCUMENT,
      icon: 'inspect',
      type: 'button',
      render: ping => /*#__PURE__*/_react.default.createElement(_view_document.ViewDocument, {
        ping: ping,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 248,
          columnNumber: 35
        }
      })
    }]
  }, ...(!isBrowserMonitor ? [{
    align: 'right',
    width: '24px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_expand_row.ExpandRowColumn, {
      item: item,
      expandedRows: expandedRows,
      setExpandedRows: setExpandedRows,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 15
      }
    })
  }] : [])];
  const getRowProps = item => {
    return {
      'data-test-subj': `row-${item.monitor.check_group}`,
      onClick: evt => {
        if (item.monitor.type !== _constants.MONITOR_TYPES.BROWSER) {
          (0, _expand_row.toggleDetails)(item, expandedRows, setExpandedRows);
        } else {
          history.push((0, _test_details_link.getTestRunDetailRelativeLink)({
            monitorId,
            checkGroup: item.monitor.check_group,
            locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id
          }));
        }
      }
    };
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    css: {
      minHeight: 200
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_test_runs_table_header.TestRunsTableHeader, {
    paginable: paginable,
    showViewHistoryButton: showViewHistoryButton,
    pings: pings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    itemId: "docId",
    itemIdToExpandedRowMap: expandedRows,
    css: {
      overflowX: isTabletOrGreater ? 'auto' : undefined
    },
    loading: pingsLoading,
    columns: columns,
    error: pingsError === null || pingsError === void 0 ? void 0 : (_pingsError$body = pingsError.body) === null || _pingsError$body === void 0 ? void 0 : _pingsError$body.message,
    items: sortedPings,
    noItemsMessage: pingsLoading ? LOADING_TEST_RUNS : NO_DATA_FOUND,
    tableLayout: "auto",
    sorting: sorting,
    onChange: handleTableChange,
    rowProps: getRowProps,
    pagination: paginable ? {
      pageIndex: page.index,
      pageSize: page.size,
      totalItemCount: total,
      pageSizeOptions: [5, 10, 20, 50]
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 7
    }
  }));
};
exports.TestRunsTable = TestRunsTable;
const MobileRowDetails = ({
  ping,
  isBrowserMonitor,
  basePath,
  locationId
}) => {
  var _ping$monitor$status, _ping$monitor, _ping$state, _ping$monitor$status2, _ping$monitor2, _ping$state2, _ping$monitor3, _ping$monitor3$durati;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_test_details_link.TestDetailsLink, {
    isBrowserMonitor: isBrowserMonitor,
    timestamp: ping['@timestamp'],
    ping: ping,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    wrap: false,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      flexBasis: 'fit-content'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
    status: (0, _status_badge.parseBadgeStatus)((_ping$monitor$status = ping === null || ping === void 0 ? void 0 : (_ping$monitor = ping.monitor) === null || _ping$monitor === void 0 ? void 0 : _ping$monitor.status) !== null && _ping$monitor$status !== void 0 ? _ping$monitor$status : 'skipped'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      textAlign: 'right'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 9
    }
  }, ping !== null && ping !== void 0 && (_ping$state = ping.state) !== null && _ping$state !== void 0 && _ping$state.id && ping.config_id && locationId && (0, _status_badge.parseBadgeStatus)((_ping$monitor$status2 = ping === null || ping === void 0 ? void 0 : (_ping$monitor2 = ping.monitor) === null || _ping$monitor2 === void 0 ? void 0 : _ping$monitor2.status) !== null && _ping$monitor$status2 !== void 0 ? _ping$monitor$status2 : 'skipped') === 'failed' ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "monitorTestRunsListViewErrorDetails",
    color: "danger",
    href: (0, _errors_list.getErrorDetailsUrl)({
      basePath,
      configId: ping.config_id,
      locationId,
      stateId: ping === null || ping === void 0 ? void 0 : (_ping$state2 = ping.state) === null || _ping$state2 === void 0 ? void 0 : _ping$state2.id
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.viewErrorDetails', {
    defaultMessage: 'View error details'
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 7
    }
  }, [{
    title: DURATION_LABEL,
    description: (0, _test_time_formats.formatTestDuration)(ping === null || ping === void 0 ? void 0 : (_ping$monitor3 = ping.monitor) === null || _ping$monitor3 === void 0 ? void 0 : (_ping$monitor3$durati = _ping$monitor3.duration) === null || _ping$monitor3$durati === void 0 ? void 0 : _ping$monitor3$durati.us)
  }].map(({
    title,
    description
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: title,
    css: {
      maxWidth: 'fit-content'
    },
    direction: "row",
    alignItems: "baseline",
    gutterSize: "xs",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 13
    }
  }, title), description))));
};
exports.MobileRowDetails = MobileRowDetails;
const LAST_10_TEST_RUNS = exports.LAST_10_TEST_RUNS = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.lastTenTestRuns', {
  defaultMessage: 'Last 10 Test Runs'
});
const SCREENSHOT_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.screenshot', {
  defaultMessage: 'Screenshot'
});
const FINAL_ATTEMPT_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.finalAttempt', {
  defaultMessage: 'This is a retest since retry on failure is enabled.'
});
const RESULT_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.result', {
  defaultMessage: 'Result'
});
const MESSAGE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.message', {
  defaultMessage: 'Message'
});
const DURATION_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.duration', {
  defaultMessage: 'Duration'
});
const LOADING_TEST_RUNS = _i18n.i18n.translate('xpack.synthetics.monitorDetails.loadingTestRuns', {
  defaultMessage: 'Loading test runs...'
});
const NO_DATA_FOUND = _i18n.i18n.translate('xpack.synthetics.monitorDetails.noDataFound', {
  defaultMessage: 'No data found'
});