"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorCompleteSparklines = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _monitor_complete_count = require("./monitor_complete_count");
var _use_monitor_query_filters = require("../hooks/use_monitor_query_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_summary/monitor_complete_sparklines.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorCompleteSparklines = props => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const {
    queryIdFilter,
    locationFilter
  } = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!queryIdFilter) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: "monitorSuccessfulSparklines",
    reportType: "kpi-over-time",
    axisTitlesVisibility: {
      x: false,
      yRight: false,
      yLeft: false
    },
    legendIsVisible: false,
    hideTicks: true,
    attributes: [{
      seriesType: 'area',
      time: props,
      reportDefinitions: queryIdFilter,
      filters: locationFilter,
      dataType: 'synthetics',
      selectedMetricField: 'monitor_successful',
      name: _monitor_complete_count.SUCCESSFUL_LABEL,
      color: euiTheme.colors.success,
      operationType: 'unique_count'
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  });
};
exports.MonitorCompleteSparklines = MonitorCompleteSparklines;