"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CHART_CELL_WIDTH = void 0;
exports.createStatusTimeBins = createStatusTimeBins;
exports.createTimeBuckets = createTimeBuckets;
exports.dateToMilli = dateToMilli;
exports.getBrushData = getBrushData;
exports.getColorBands = getColorBands;
exports.getErrorVizColor = getErrorVizColor;
exports.getSkippedVizColor = getSkippedVizColor;
exports.getStatusEffectiveValue = getStatusEffectiveValue;
exports.getXAxisLabelFormatter = getXAxisLabelFormatter;
exports.indexBinsByEndTime = indexBinsByEndTime;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHART_CELL_WIDTH = exports.CHART_CELL_WIDTH = 17;
function getColorBands(euiTheme, colorMode) {
  const colorTransitionFn = colorMode === _eui.COLOR_MODES_STANDARD.dark ? _eui.transparentize : _eui.tint;
  const SUCCESS_COLOR = euiTheme.colors.success;
  const DANGER_COLOR = euiTheme.colors.danger;
  return [{
    color: DANGER_COLOR,
    start: -Infinity,
    end: -1
  }, {
    color: DANGER_COLOR,
    start: -1,
    end: -0.75
  }, {
    color: colorTransitionFn(DANGER_COLOR, 0.25),
    start: -0.75,
    end: -0.5
  }, {
    color: colorTransitionFn(DANGER_COLOR, 0.5),
    start: -0.5,
    end: -0.25
  }, {
    color: colorTransitionFn(DANGER_COLOR, 0.75),
    start: -0.25,
    end: -0.000000001
  }, {
    color: getSkippedVizColor(euiTheme),
    start: -0.000000001,
    end: 0.000000001
  }, {
    color: colorTransitionFn(SUCCESS_COLOR, 0.5),
    start: 0.000000001,
    end: 0.25
  }, {
    color: colorTransitionFn(SUCCESS_COLOR, 0.35),
    start: 0.25,
    end: 0.5
  }, {
    color: colorTransitionFn(SUCCESS_COLOR, 0.2),
    start: 0.5,
    end: 0.8
  }, {
    color: SUCCESS_COLOR,
    start: 0.8,
    end: 1
  }, {
    color: SUCCESS_COLOR,
    start: 1,
    end: Infinity
  }];
}
function getSkippedVizColor(euiTheme) {
  return euiTheme.colors.lightestShade;
}
function getErrorVizColor(euiTheme) {
  return euiTheme.colors.textDanger;
}
function getXAxisLabelFormatter(interval) {
  return value => {
    const m = (0, _moment.default)(value);
    const [hours, minutes] = [m.hours(), m.minutes()];
    const isFirstBucketOfADay = hours === 0 && minutes <= 36;
    const isIntervalAcrossDays = interval >= 24 * 60;
    return (0, _moment.default)(value).format(isFirstBucketOfADay || isIntervalAcrossDays ? 'l' : 'HH:mm');
  };
}
function createTimeBuckets(intervalMinutes, from, to) {
  const currentMark = getEndTime(intervalMinutes, to);
  const buckets = [];
  let tick = currentMark;
  let maxIterations = 5000;
  while (tick >= from && maxIterations > 0) {
    const start = tick - Math.floor(intervalMinutes * 60 * 1000);
    buckets.unshift({
      start,
      end: tick
    });
    tick = start;
    --maxIterations;
  }
  return buckets;
}
function createStatusTimeBins(timeBuckets, heatmapData) {
  return timeBuckets.map(({
    start,
    end
  }) => {
    if (!Array.isArray(heatmapData)) {
      return {
        start,
        end,
        ups: 0,
        downs: 0,
        value: 0
      };
    }
    const {
      ups,
      downs
    } = heatmapData.filter(({
      key
    }) => key >= start && key <= end).reduce((acc, cur) => ({
      ups: acc.ups + cur.up.value,
      downs: acc.downs + cur.down.value
    }), {
      ups: 0,
      downs: 0
    });
    return {
      start,
      end,
      ups,
      downs,
      value: ups + downs === 0 ? 0 : getStatusEffectiveValue(ups, downs)
    };
  });
}
function indexBinsByEndTime(bins) {
  return bins.reduce((acc, cur) => {
    return acc.set(cur.end, cur);
  }, new Map());
}
function dateToMilli(date) {
  if (typeof date === 'number') {
    return date;
  }
  let d = date;
  if (typeof date === 'string') {
    d = _datemath.default.parse(date, {
      momentInstance: _moment.default
    });
  }
  return (0, _moment.default)(d).valueOf();
}
function getBrushData(e) {
  var _e$x, _e$x2;
  const [from, to] = [Number((_e$x = e.x) === null || _e$x === void 0 ? void 0 : _e$x[0]), Number((_e$x2 = e.x) === null || _e$x2 === void 0 ? void 0 : _e$x2[1])];
  const [fromUtc, toUtc] = [(0, _moment.default)(from).format(), (0, _moment.default)(to).format()];
  return {
    from,
    to,
    fromUtc,
    toUtc
  };
}
function getStatusEffectiveValue(ups, downs) {
  if (ups === downs) {
    return -0.1;
  }
  return (ups - downs) / (ups + downs);
}
function getEndTime(intervalMinutes, to) {
  const intervalUnderHour = Math.floor(intervalMinutes) % 60;
  const upperBoundMinutes = Math.ceil(new Date(to).getUTCMinutes() / intervalUnderHour) * intervalUnderHour;
  return (0, _moment.default)(to).utc().startOf('hour').add(upperBoundMinutes, 'minute').valueOf();
}