"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _code_editor = require("./code_editor");
var _script_recorder_fields = require("./script_recorder_fields");
var _types = require("../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/fields/source_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var SourceType = /*#__PURE__*/function (SourceType) {
  SourceType["INLINE"] = "syntheticsBrowserInlineConfig";
  SourceType["SCRIPT_RECORDER"] = "syntheticsBrowserScriptRecorderConfig";
  SourceType["ZIP"] = "syntheticsBrowserZipURLConfig";
  return SourceType;
}(SourceType || {});
const SourceField = ({
  onChange,
  onBlur,
  value,
  isEditFlow = false
}) => {
  const [sourceType, setSourceType] = (0, _react.useState)(value.type === 'inline' ? SourceType.INLINE : SourceType.SCRIPT_RECORDER);
  const [config, setConfig] = (0, _react.useState)(value);
  (0, _react.useEffect)(() => {
    onChange(config);
  }, [config, onChange]);
  const allTabs = [{
    id: 'syntheticsBrowserScriptRecorderConfig',
    name: isEditFlow ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorConfig.scriptRecorderEdit.label",
      defaultMessage: "Upload new script",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorConfig.scriptRecorder.label",
      defaultMessage: "Upload script",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }),
    'data-test-subj': 'syntheticsSourceTab__scriptRecorder',
    content: /*#__PURE__*/_react.default.createElement(_script_recorder_fields.ScriptRecorderFields, {
      onChange: ({
        scriptText,
        fileName
      }) => {
        setConfig(prevConfig => ({
          ...prevConfig,
          script: scriptText,
          type: 'recorder',
          fileName
        }));
      },
      script: config.script,
      isEditable: isEditFlow,
      fileName: config.fileName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    })
  }, {
    id: 'syntheticsBrowserInlineConfig',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.addEditMonitor.scriptEditor.label",
      defaultMessage: "Script editor",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }),
    'data-test-subj': `syntheticsSourceTab__inline`,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.addEditMonitor.scriptEditor.helpText",
        defaultMessage: "Runs Synthetic test scripts that are defined inline.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 13
        }
      }),
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_code_editor.CodeEditor, {
      ariaLabel: _i18n.i18n.translate('xpack.synthetics.addEditMonitor.scriptEditor.ariaLabel', {
        defaultMessage: 'JavaScript code editor'
      }),
      id: "javascript",
      languageId: _types.MonacoEditorLangId.JAVASCRIPT,
      onChange: code => {
        setConfig(prevConfig => ({
          ...prevConfig,
          script: code
        }));
        onBlur(_types.ConfigKey.SOURCE_INLINE);
      },
      value: config.script,
      placeholder: _i18n.i18n.translate('xpack.synthetics.addEditMonitor.scriptEditor.placeholder', {
        defaultMessage: '// Paste your Playwright script here...'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 11
      }
    }))
  }];
  if (isEditFlow) {
    allTabs.reverse();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: allTabs,
    initialSelectedTab: isEditFlow ? allTabs.find(tab => tab.id === SourceType.INLINE) : allTabs.find(tab => tab.id === sourceType),
    autoFocus: "selected",
    onTabClick: tab => {
      if (tab.id !== sourceType) {
        setConfig({
          script: '',
          type: tab.id === SourceType.INLINE ? 'inline' : 'recorder',
          fileName: ''
        });
      }
      setSourceType(tab.id);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  });
};
exports.SourceField = SourceField;