"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyValuePairsField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/fields/key_value_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledFieldset = (0, _styledComponents.default)(_eui.EuiFormFieldset)`
  &&& {
    legend {
      width: calc(100% - 52px); // right margin + flex item padding
      margin-right: 40px;
    }
    .euiFlexGroup {
      margin-left: 0;
    }
    .euiFlexItem {
      margin-left: 0;
      padding-left: 12px;
    }
  }
`;
const StyledField = (0, _styledComponents.default)(_eui.EuiFieldText)`
  text-align: left;
`;
const KeyValuePairsField = ({
  addPairControlLabel,
  defaultPairs,
  onChange,
  onBlur,
  'data-test-subj': dataTestSubj,
  readOnly,
  keyLabel,
  valueLabel
}) => {
  const [pairs, setPairs] = (0, _react.useState)(defaultPairs);
  const handleOnChange = (0, _react.useCallback)((event, index, isKey) => {
    const targetValue = event.target.value;
    setPairs(prevPairs => {
      const newPairs = [...prevPairs];
      const [prevKey, prevValue] = prevPairs[index];
      newPairs[index] = isKey ? [targetValue, prevValue] : [prevKey, targetValue];
      return newPairs;
    });
  }, [setPairs]);
  const handleAddPair = (0, _react.useCallback)(() => {
    setPairs(prevPairs => [['', ''], ...prevPairs]);
  }, [setPairs]);
  const handleDeletePair = (0, _react.useCallback)(index => {
    setPairs(prevPairs => {
      const newPairs = [...prevPairs];
      newPairs.splice(index, 1);
      return [...newPairs];
    });
  }, [setPairs]);
  (0, _react.useEffect)(() => {
    onChange(pairs);
  }, [onChange, pairs]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plus",
    onClick: handleAddPair,
    "data-test-subj": `${dataTestSubj}__button`,
    isDisabled: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, addPairControlLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(StyledFieldset, {
    legend: !!pairs.length ? {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 21
        }
      }, keyLabel || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.keyValuePairsField.key.label",
        defaultMessage: "Key",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 25
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 21
        }
      }, valueLabel || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.keyValuePairsField.value.label",
        defaultMessage: "Value",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 25
        }
      })))
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, pairs.map((pair, index) => {
    const [key, value] = pair;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayoutDelimited, {
      fullWidth: true,
      append: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "syntheticsKeyValuePairsFieldButton",
        iconType: "trash",
        "aria-label": _i18n.i18n.translate('xpack.synthetics.keyValuePairsField.deleteItem.label', {
          defaultMessage: 'Delete item number {index}, {key}:{value}',
          values: {
            index: index + 1,
            key,
            value
          }
        }),
        onClick: () => handleDeletePair(index),
        isDisabled: readOnly,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 21
        }
      })),
      startControl: /*#__PURE__*/_react.default.createElement(StyledField, {
        controlOnly: true,
        "aria-label": _i18n.i18n.translate('xpack.synthetics.keyValuePairsField.key.ariaLabel', {
          defaultMessage: 'Key'
        }),
        "data-test-subj": `keyValuePairsKey${index}`,
        value: key,
        onChange: event => handleOnChange(event, index, true),
        onBlur: () => onBlur === null || onBlur === void 0 ? void 0 : onBlur(),
        readOnly: readOnly,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 19
        }
      }),
      endControl: /*#__PURE__*/_react.default.createElement(StyledField, {
        controlOnly: true,
        "aria-label": _i18n.i18n.translate('xpack.synthetics.keyValuePairsField.value.ariaLabel', {
          defaultMessage: 'Value'
        }),
        "data-test-subj": `keyValuePairsValue${index}`,
        value: value,
        onChange: event => handleOnChange(event, index, false),
        onBlur: () => onBlur === null || onBlur === void 0 ? void 0 : onBlur(),
        readOnly: readOnly,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 19
        }
      }),
      delimiter: ":",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 15
      }
    }));
  })));
};
exports.KeyValuePairsField = KeyValuePairsField;