"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GettingStartedPage = exports.GettingStartedOnPrem = exports.GettingStartedLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/kibana-react-plugin/public");
var _hooks = require("../../hooks");
var _use_locations_api = require("../settings/private_locations/hooks/use_locations_api");
var _monitor_detail_flyout = require("../monitors_page/overview/overview/monitor_detail_flyout");
var _state = require("../../state");
var _ui = require("../../../../../common/constants/ui");
var _simple_monitor_form = require("./simple_monitor_form");
var _add_or_edit_location_flyout = require("../settings/private_locations/add_or_edit_location_flyout");
var _agent_policies = require("../../state/agent_policies");
var _actions = require("../../state/private_locations/actions");
var _selectors = require("../../state/private_locations/selectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/getting_started/getting_started_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GettingStartedPage = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    observabilityAIAssistant
  } = (0, _public.useKibana)().services;
  const setScreenContext = observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service.setScreenContext;
  (0, _hooks.useEnablement)();
  (0, _react.useEffect)(() => {
    dispatch((0, _state.getServiceLocations)());
    dispatch(_agent_policies.getAgentPoliciesAction.get());
    return () => {
      dispatch((0, _state.cleanMonitorListState)());
    };
  }, [dispatch]);
  (0, _hooks.useBreadcrumbs)([{
    text: MONITORING_OVERVIEW_LABEL
  }]); // No extra breadcrumbs on overview

  const {
    locations,
    loading: allLocationsLoading
  } = (0, _hooks.useLocations)();
  const {
    loading: agentPoliciesLoading
  } = (0, _reactRedux.useSelector)(_agent_policies.selectAgentPolicies);
  const loading = allLocationsLoading || agentPoliciesLoading;
  const hasNoLocations = !allLocationsLoading && locations.length === 0;
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext({
      screenDescription: hasNoLocations ? 'The user has no locations configured.' : `The user has ${locations.length} locations configured: ${JSON.stringify(locations)}`,
      starterPrompts: [...(hasNoLocations ? [{
        title: _i18n.i18n.translate('xpack.synthetics.aiAssistant.starterPrompts.explainNoData.title', {
          defaultMessage: 'Explain'
        }),
        prompt: _i18n.i18n.translate('xpack.synthetics.aiAssistant.starterPrompts.explainNoData.prompt', {
          defaultMessage: "Why don't I see any monitors?"
        }),
        icon: 'sparkles'
      }] : [])]
    });
  }, [setScreenContext, hasNoLocations, locations]);
  return !loading ? /*#__PURE__*/_react.default.createElement(Wrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, hasNoLocations ? /*#__PURE__*/_react.default.createElement(GettingStartedOnPrem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 18
      }
    }, CREATE_SINGLE_PAGE_LABEL),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 15
      }
    }, OR_LABEL, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsGettingStartedPageLink",
      href: history.createHref({
        pathname: _ui.MONITOR_ADD_ROUTE
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 17
      }
    }, SELECT_DIFFERENT_MONITOR), _i18n.i18n.translate('xpack.synthetics.gettingStarted.createSingle.description', {
      defaultMessage: ' to get started with Elastic Synthetics Monitoring.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_simple_monitor_form.SimpleMonitorForm, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 15
      }
    })),
    footer: /*#__PURE__*/_react.default.createElement(GettingStartedLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  })) : /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  });
};
exports.GettingStartedPage = GettingStartedPage;
const GettingStartedOnPrem = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _hooks.useBreadcrumbs)([{
    text: MONITORING_OVERVIEW_LABEL
  }]); // No extra breadcrumbs on overview

  const isPrivateLocationFlyoutVisible = (0, _reactRedux.useSelector)(_selectors.selectPrivateLocationFlyoutVisible);
  const setIsFlyoutOpen = (0, _react.useCallback)(val => dispatch((0, _actions.setIsPrivateLocationFlyoutVisible)(val)), [dispatch]);
  const {
    onCreateLocationAPI,
    privateLocations
  } = (0, _use_locations_api.usePrivateLocationsAPI)();
  const handleSubmit = formData => {
    onCreateLocationAPI(formData);
  };

  // make sure flyout is closed when first visiting the page
  (0, _react.useEffect)(() => {
    setIsFlyoutOpen(false);
  }, [setIsFlyoutOpen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 16
      }
    }, GET_STARTED_LABEL),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 15
      }
    }, CREATE_LOCATION_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 15
      }
    }, PUBLIC_LOCATION_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "plusInCircleFilled",
      "data-test-subj": "gettingStartedAddLocationButton",
      onClick: () => setIsFlyoutOpen(true),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 15
      }
    }, CREATE_LOCATION_LABEL))),
    footer: /*#__PURE__*/_react.default.createElement(GettingStartedLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }), isPrivateLocationFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_add_or_edit_location_flyout.AddOrEditLocationFlyout, {
    onCloseFlyout: () => setIsFlyoutOpen(false),
    onSubmit: handleSubmit,
    privateLocations: privateLocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }) : null);
};
exports.GettingStartedOnPrem = GettingStartedOnPrem;
const GettingStartedLink = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  color: "subdued",
  className: "eui-displayInlineBlock",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 190,
    columnNumber: 5
  }
}, FOR_MORE_INFO_LABEL), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  "data-test-subj": "syntheticsGettingStartedOnPremLink",
  href: "https://www.elastic.co/guide/en/observability/current/synthetics-get-started.html",
  target: "_blank",
  className: "eui-displayInline",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 193,
    columnNumber: 5
  }
}, GETTING_STARTED_LABEL));
exports.GettingStartedLink = GettingStartedLink;
const Wrapper = _styledComponents.default.div`
  &&& {
    .euiEmptyPrompt__content {
      max-width: 40em;
      padding: 0;
    }
  }
`;
const FOR_MORE_INFO_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.forMoreInfo', {
  defaultMessage: 'For more information, read our'
});
const GETTING_STARTED_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.gettingStartedLabel', {
  defaultMessage: 'Getting Started Guide'
});
const CREATE_SINGLE_PAGE_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.createSinglePageLabel', {
  defaultMessage: 'Create a single page browser monitor'
});
const GET_STARTED_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.createLocationHeading', {
  defaultMessage: 'Get started with synthetic monitoring'
});
const PRIVATE_LOCATION_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.privateLocationLabel', {
  defaultMessage: 'private location'
});
const CREATE_LOCATION_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.createLocationLabel', {
  defaultMessage: 'Create location'
});
const CREATE_LOCATION_DESCRIPTION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.gettingStarted.createLocationDescription",
  defaultMessage: "To start creating monitors, you first need to create a {link}. Private locations allow you to run monitors from your own premises. They require an Elastic agent and Agent policy which you can control and maintain via Fleet.",
  values: {
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsLink",
      href: "https://www.elastic.co/guide/en/observability/current/synthetics-private-location.html",
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 9
      }
    }, PRIVATE_LOCATION_LABEL)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 250,
    columnNumber: 3
  }
});
const PUBLIC_LOCATION_DESCRIPTION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.gettingStarted.publicLocationDescription",
  defaultMessage: "In {link} you can also use {elasticManagedLink}. With it, you can create and run monitors in multiple locations without having to manage your own infrastructure. Elastic takes care of software updates and capacity planning for you.",
  values: {
    elasticManagedLink: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.synthetics.gettingStarted.gettingStartedLabel.elasticManagedLink', {
      defaultMessage: 'Elastic’s global managed testing infrastructure'
    })),
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsElasticCloudLink",
      href: "https://www.elastic.co/cloud/",
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.synthetics.gettingStarted.gettingStartedLabel.elasticCloudDeployments', {
      defaultMessage: 'Elastic Cloud'
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 268,
    columnNumber: 3
  }
});
const SELECT_DIFFERENT_MONITOR = _i18n.i18n.translate('xpack.synthetics.gettingStarted.gettingStartedLabel.selectDifferentMonitor', {
  defaultMessage: 'select a different monitor type'
});
const OR_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.orLabel', {
  defaultMessage: 'Or'
});
const MONITORING_OVERVIEW_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.heading', {
  defaultMessage: 'Monitors'
});