"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorDetailsPage = ErrorDetailsPage;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _test_run_error_info = require("../test_run_details/components/test_run_error_info");
var _step_duration_panel = require("../monitor_details/monitor_summary/step_duration_panel");
var _last_test_run = require("../monitor_details/monitor_summary/last_test_run");
var _use_step_details = require("./hooks/use_step_details");
var _step_details = require("../test_run_details/components/step_details");
var _panel_with_title = require("../common/components/panel_with_title");
var _use_error_failed_tests = require("./hooks/use_error_failed_tests");
var _use_journey_steps = require("../monitor_details/hooks/use_journey_steps");
var _failed_tests_list = require("./components/failed_tests_list");
var _error_timeline = require("./components/error_timeline");
var _use_error_details_breadcrumbs = require("./hooks/use_error_details_breadcrumbs");
var _step_image = require("../step_details_page/step_screenshot/step_image");
var _monitor_details_panel_container = require("../monitor_details/monitor_summary/monitor_details_panel_container");
var _use_date_format = require("../../../../hooks/use_date_format");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/error_details/error_details_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ErrorDetailsPage() {
  var _failedTests$0$monito, _failedTests$, _lastTestRun$state, _data$details, _data$details2, _data$details3;
  const {
    failedTests,
    loading
  } = (0, _use_error_failed_tests.useErrorFailedTests)();
  const checkGroupId = (_failedTests$0$monito = failedTests === null || failedTests === void 0 ? void 0 : (_failedTests$ = failedTests[0]) === null || _failedTests$ === void 0 ? void 0 : _failedTests$.monitor.check_group) !== null && _failedTests$0$monito !== void 0 ? _failedTests$0$monito : '';
  const {
    data,
    isFailedStep,
    failedStep,
    loading: stepsLoading
  } = (0, _use_journey_steps.useJourneySteps)(checkGroupId);
  const lastTestRun = failedTests === null || failedTests === void 0 ? void 0 : failedTests[0];
  const formatter = (0, _use_date_format.useDateFormat)();
  const startedAt = formatter(lastTestRun === null || lastTestRun === void 0 ? void 0 : (_lastTestRun$state = lastTestRun.state) === null || _lastTestRun$state === void 0 ? void 0 : _lastTestRun$state.started_at);
  (0, _use_error_details_breadcrumbs.useErrorDetailsBreadcrumbs)([{
    text: startedAt
  }]);
  const stepDetails = (0, _use_step_details.useStepDetails)({
    checkGroup: lastTestRun === null || lastTestRun === void 0 ? void 0 : lastTestRun.monitor.check_group
  });
  const isBrowser = (data === null || data === void 0 ? void 0 : (_data$details = data.details) === null || _data$details === void 0 ? void 0 : _data$details.journey.monitor.type) === 'browser';
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, {
    title: TIMELINE_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_error_timeline.ErrorTimeline, {
    lastTestRun: lastTestRun,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    style: {
      minWidth: 0
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, {
    title: FAILED_TESTS_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_failed_tests_list.FailedTestsList, {
    failedTests: failedTests,
    loading: loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  })), isBrowser && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_step_details.StepDetails, (0, _extends2.default)({}, stepDetails, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_last_test_run.LastTestRunComponent, {
    latestPing: lastTestRun,
    loading: loading,
    stepsData: data,
    stepsLoading: stepsLoading,
    isErrorDetails: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }), isBrowser && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_test_run_error_info.TestRunErrorInfo, {
    journeyDetails: data === null || data === void 0 ? void 0 : data.details,
    showErrorTitle: false,
    showErrorLogs: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      height: 'fit-content'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, (data === null || data === void 0 ? void 0 : (_data$details2 = data.details) === null || _data$details2 === void 0 ? void 0 : _data$details2.journey) && failedStep && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_step_image.StepImage, {
    ping: data === null || data === void 0 ? void 0 : (_data$details3 = data.details) === null || _data$details3 === void 0 ? void 0 : _data$details3.journey,
    step: failedStep,
    isFailed: isFailedStep,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_step_duration_panel.StepDurationPanel, {
    doBreakdown: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor_details_panel_container.MonitorDetailsPanelContainer, {
    hideLocations: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }))));
}
const TIMELINE_LABEL = _i18n.i18n.translate('xpack.synthetics.errors.timeline.title', {
  defaultMessage: 'Timeline'
});
const FAILED_TESTS_LABEL = _i18n.i18n.translate('xpack.synthetics.errors.failedTests', {
  defaultMessage: 'Failed tests'
});