"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorMWsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _public = require("@kbn/kibana-react-plugin/public");
var _mws_callout_content = require("./mws_callout_content");
var _runtime_types = require("../../../../../../common/runtime_types");
var _use_selected_monitor = require("../../monitor_details/hooks/use_selected_monitor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/mws_callout/monitor_mws_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorMWsCallout = () => {
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const services = (0, _public.useKibana)().services;
  const {
    data
  } = (0, _alertsUiShared.useFetchActiveMaintenanceWindows)(services, {
    enabled: true
  });
  if (!monitor) {
    return null;
  }
  const monitorMWs = monitor[_runtime_types.ConfigKey.MAINTENANCE_WINDOWS];
  const hasMonitorMWs = monitorMWs && monitorMWs.length > 0;
  if (data !== null && data !== void 0 && data.length && hasMonitorMWs) {
    const activeMWs = data.filter(mw => monitorMWs.includes(mw.id));
    if (activeMWs) {
      return /*#__PURE__*/_react.default.createElement(_mws_callout_content.MwsCalloutContent, {
        activeMWs: activeMWs,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 14
        }
      });
    }
  }
  return null;
};
exports.MonitorMWsCallout = MonitorMWsCallout;