"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTestRunDetailRelativeLink = exports.getTestRunDetailLink = exports.TestDetailsLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_selected_location = require("../../monitor_details/hooks/use_selected_location");
var _contexts = require("../../../contexts");
var _use_date_format = require("../../../../../hooks/use_date_format");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/links/test_details_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TestDetailsLink = ({
  isBrowserMonitor,
  timestamp,
  ping
}) => {
  var _ping$config_id;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const formatter = (0, _use_date_format.useDateFormat)();
  const timestampText = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: {
      fontWeight: euiTheme.font.weight.medium
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, formatter(timestamp));
  return isBrowserMonitor ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsTestDetailsLinkLink",
    href: getTestRunDetailLink({
      basePath,
      checkGroup: ping.monitor.check_group,
      monitorId: (_ping$config_id = ping === null || ping === void 0 ? void 0 : ping.config_id) !== null && _ping$config_id !== void 0 ? _ping$config_id : '',
      locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, timestampText) : timestampText;
};
exports.TestDetailsLink = TestDetailsLink;
const getTestRunDetailLink = ({
  monitorId,
  basePath,
  checkGroup,
  locationId
}) => {
  const testRunUrl = `/monitor/${monitorId}/test-run/${checkGroup}?locationId=${locationId}`;
  return `${basePath}/app/synthetics${testRunUrl}`;
};
exports.getTestRunDetailLink = getTestRunDetailLink;
const getTestRunDetailRelativeLink = ({
  monitorId,
  checkGroup,
  locationId
}) => {
  return `/monitor/${monitorId}/test-run/${checkGroup}?locationId=${locationId}`;
};
exports.getTestRunDetailRelativeLink = getTestRunDetailRelativeLink;