"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorLocationSelect = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/monitor_location_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorLocationSelect = ({
  monitorLocations,
  configId,
  selectedLocation,
  compressed,
  onChange,
  isDisabled
}) => {
  const theme = (0, _eui.useEuiTheme)();
  const {
    locations: locationsStatus,
    loading: loadingLocationsStatus
  } = (0, _hooks.useStatusByLocation)({
    configId,
    monitorLocations
  });
  const [isLocationListOpen, setIsLocationListOpen] = (0, _react.useState)(false);
  const openLocationList = (0, _react.useCallback)(() => setIsLocationListOpen(true), []);
  const closeLocationList = (0, _react.useCallback)(() => setIsLocationListOpen(false), []);
  const locationList = (0, _react.useMemo)(() => {
    if (!selectedLocation || !monitorLocations) {
      return '';
    }
    const showSelection = monitorLocations.length === 1 && monitorLocations[0].id !== (selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id);
    if (monitorLocations.length > 1 || showSelection) {
      const button = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsLocationListLink",
        onClick: openLocationList,
        disabled: isDisabled,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 9
        }
      }, selectedLocation.label, " ", !isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "arrowDown",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 51
        }
      }) : null);
      const menuItems = loadingLocationsStatus && !locationsStatus ? [/*#__PURE__*/_react.default.createElement("span", {
        key: "loading",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 14
        }
      }, "Loading...")] : locationsStatus.map(location => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: location.label,
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
            color: location.color,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 79,
              columnNumber: 27
            }
          }),
          css: (selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id) === location.id ? {
            textDecoration: 'underline',
            backgroundColor: theme.euiTheme.colors.lightShade,
            pointerEvents: 'none'
          } : undefined,
          onClick: (selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id) !== location.id ? () => {
            closeLocationList();
            onChange(location.id, location.label);
          } : undefined,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 77,
            columnNumber: 19
          }
        }, location.label);
      }).filter(l => typeof l !== undefined);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        button: button,
        isOpen: isLocationListOpen,
        closePopover: closeLocationList,
        panelPaddingSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
        items: menuItems,
        size: "s",
        title: _i18n.i18n.translate('xpack.synthetics.monitorLocation.locationContextMenuTitleLabel', {
          defaultMessage: 'Go to location'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 11
        }
      }));
    } else {
      return selectedLocation.label;
    }
  }, [closeLocationList, isDisabled, isLocationListOpen, loadingLocationsStatus, locationsStatus, monitorLocations, onChange, openLocationList, selectedLocation, theme.euiTheme.colors.lightShade]);
  if (!selectedLocation || !monitorLocations) {
    if (selectedLocation) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: compressed,
        listItems: [{
          title: LOCATION_LABEL,
          description: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label
        }],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: compressed,
      listItems: [{
        title: LOCATION_LABEL,
        description: /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
          lines: 1,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 149,
            columnNumber: 59
          }
        })
      }],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: compressed,
    listItems: [{
      title: LOCATION_LABEL,
      description: locationList
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 5
    }
  });
};
exports.MonitorLocationSelect = MonitorLocationSelect;
const LOCATION_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorLocation.locationLabel', {
  defaultMessage: 'Location'
});