"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MISSING_RULES_PRIVILEGES_LABEL = exports.AlertingCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _common = require("@kbn/observability-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _useSessionStorage = _interopRequireDefault(require("react-use/lib/useSessionStorage"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _settings = require("../../../state/settings");
var _selectors = require("../../../state/alert_rules/selectors");
var _state = require("../../../state");
var _actions = require("../../../state/settings/actions");
var _contexts = require("../../../contexts");
var _runtime_types = require("../../../../../../common/runtime_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/alerting_callout/alerting_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertingCallout = ({
  isAlertingEnabled
}) => {
  var _useKibana$services$s;
  const dispatch = (0, _reactRedux.useDispatch)();
  const defaultRules = (0, _reactRedux.useSelector)(_selectors.selectSyntheticsAlerts);
  const rulesLoaded = (0, _reactRedux.useSelector)(_selectors.selectSyntheticsAlertsLoaded);
  const {
    settings
  } = (0, _reactRedux.useSelector)(_settings.selectDynamicSettings);
  const hasDefaultConnector = !settings || !(0, _lodash.isEmpty)(settings === null || settings === void 0 ? void 0 : settings.defaultConnectors);
  const defaultRuleEnabled = (settings === null || settings === void 0 ? void 0 : settings.defaultTLSRuleEnabled) || (settings === null || settings === void 0 ? void 0 : settings.defaultStatusRuleEnabled);
  const {
    canSave
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    data: {
      monitors
    },
    loaded: monitorsLoaded
  } = (0, _reactRedux.useSelector)(_state.selectMonitorListState);
  const syntheticsLocators = (_useKibana$services$s = (0, _public2.useKibana)().services.share) === null || _useKibana$services$s === void 0 ? void 0 : _useKibana$services$s.url.locators;
  const locator = syntheticsLocators === null || syntheticsLocators === void 0 ? void 0 : syntheticsLocators.get(_common.syntheticsSettingsLocatorID);
  const {
    data: url
  } = (0, _public.useFetcher)(() => {
    return locator === null || locator === void 0 ? void 0 : locator.getUrl({});
  }, [locator]);
  const hasAlertingConfigured = isAlertingEnabled !== null && isAlertingEnabled !== void 0 ? isAlertingEnabled : monitorsLoaded && monitors.some(monitor => {
    var _monitor$ConfigKey$AL, _monitor$ConfigKey$AL2;
    return (_monitor$ConfigKey$AL = monitor[_runtime_types.ConfigKey.ALERT_CONFIG]) === null || _monitor$ConfigKey$AL === void 0 ? void 0 : (_monitor$ConfigKey$AL2 = _monitor$ConfigKey$AL.status) === null || _monitor$ConfigKey$AL2 === void 0 ? void 0 : _monitor$ConfigKey$AL2.enabled;
  });
  const showCallout = !hasDefaultConnector && hasAlertingConfigured && defaultRuleEnabled;
  const hasDefaultRules = !rulesLoaded || Boolean((defaultRules === null || defaultRules === void 0 ? void 0 : defaultRules.statusRule) && (defaultRules === null || defaultRules === void 0 ? void 0 : defaultRules.tlsRule));
  const missingRules = !hasDefaultRules && !canSave;
  (0, _react.useEffect)(() => {
    dispatch(_actions.getDynamicSettingsAction.get());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(MissingRulesCallout, {
    url: url,
    missingConfig: Boolean(showCallout),
    missingRules: missingRules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }));
};
exports.AlertingCallout = AlertingCallout;
const MissingRulesCallout = ({
  url,
  missingRules,
  missingConfig
}) => {
  const [isHidden, setIsHidden] = (0, _useSessionStorage.default)('MissingRulesCalloutHidden', false);
  if (!missingConfig && !missingRules || isHidden) {
    return null;
  }
  const point = missingRules === missingConfig ? '* ' : '';
  const configCallout = missingConfig ? /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, `${point}${MISSING_CONFIG_LABEL}`) : null;
  const rulesCallout = missingRules ? /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, `${point}${MISSING_RULES_PRIVILEGES_LABEL}`) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.alerting.noConnectorsCallout.header",
      defaultMessage: "Alerts are not being sent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, configCallout, rulesCallout, missingConfig && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsAlertingCalloutLinkButtonButton",
    href: url,
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.alerting.noConnectorsCallout.button",
    defaultMessage: "Configure now",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsMissingRulesCalloutRemindMeLaterButton",
    onClick: () => {
      setIsHidden(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.alerting.remindMeLater.button",
    defaultMessage: "Remind me later",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  })));
};
const MISSING_CONFIG_LABEL = _i18n.i18n.translate('xpack.synthetics.alerting.noConnectorsCallout.content', {
  defaultMessage: 'You have monitors with alerting enabled, but there is no default connector configured to send those alerts.'
});
const MISSING_RULES_PRIVILEGES_LABEL = exports.MISSING_RULES_PRIVILEGES_LABEL = _i18n.i18n.translate('xpack.synthetics.alerting.missingRules.content', {
  defaultMessage: 'You have monitors with alerting enabled, but there is no rules configured to send those alerts. Default rules are automatically created when user with write privileges opens Synthetics app.'
});