"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToggleAlertFlyoutButton = exports.EDIT_TLS_RULE_NAME = exports.EDIT_STATUS_RULE = exports.CREATE_TLS_RULE_NAME = exports.CREATE_STATUS_RULE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _rule_name_with_loading = require("./rule_name_with_loading");
var _synthetics_alerts = require("../../../../../common/constants/synthetics_alerts");
var _manage_rules_link = require("../common/links/manage_rules_link");
var _translations = require("./hooks/translations");
var _use_synthetics_rules = require("./hooks/use_synthetics_rules");
var _state = require("../../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/toggle_alert_flyout_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ToggleAlertFlyoutButton = () => {
  var _application$capabili, _application$capabili2;
  const dispatch = (0, _reactRedux.useDispatch)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const {
    application
  } = (0, _public.useKibana)().services;
  const hasUptimeWrite = (_application$capabili = application === null || application === void 0 ? void 0 : (_application$capabili2 = application.capabilities.uptime) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.save) !== null && _application$capabili !== void 0 ? _application$capabili : false;
  const {
    EditAlertFlyout,
    loading,
    NewRuleFlyout
  } = (0, _use_synthetics_rules.useSyntheticsRules)(isOpen);
  const {
    loaded,
    data: monitors
  } = (0, _reactRedux.useSelector)(_state.selectMonitorListState);
  const hasMonitors = loaded && monitors.absoluteTotal && monitors.absoluteTotal > 0;
  const panels = [{
    id: 0,
    items: [{
      name: _translations.STATUS_RULE_NAME,
      'data-test-subj': 'manageStatusRuleName',
      panel: 1
    }, {
      name: _translations.TLS_RULE_NAME,
      'data-test-subj': 'manageTlsRuleName',
      panel: 2
    }, {
      'aria-label': _translations.ToggleFlyoutTranslations.navigateToAlertingUIAriaLabel,
      'data-test-subj': 'xpack.synthetics.navigateToAlertingUi',
      name: /*#__PURE__*/_react.default.createElement(_manage_rules_link.ManageRulesLink, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 17
        }
      }),
      icon: 'tableOfContents'
    }]
  }, {
    id: 1,
    items: [{
      name: CREATE_STATUS_RULE,
      'data-test-subj': 'createNewStatusRule',
      icon: 'plusInCircle',
      onClick: () => {
        dispatch((0, _state.setAlertFlyoutVisible)({
          id: _synthetics_alerts.SYNTHETICS_STATUS_RULE,
          isNewRuleFlyout: true
        }));
        setIsOpen(false);
      }
    }, {
      'aria-label': _translations.ToggleFlyoutTranslations.toggleMonitorStatusAriaLabel,
      'data-test-subj': 'editDefaultStatusRule',
      name: /*#__PURE__*/_react.default.createElement(_rule_name_with_loading.RuleNameWithLoading, {
        ruleName: EDIT_STATUS_RULE,
        isLoading: loading,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 17
        }
      }),
      onClick: () => {
        dispatch((0, _state.setAlertFlyoutVisible)({
          id: _synthetics_alerts.SYNTHETICS_STATUS_RULE,
          isNewRuleFlyout: false
        }));
        setIsOpen(false);
      },
      toolTipContent: !hasUptimeWrite ? noWritePermissionsTooltipContent : null,
      disabled: !hasUptimeWrite || loading,
      icon: 'bell'
    }]
  }, {
    id: 2,
    items: [{
      name: CREATE_TLS_RULE_NAME,
      'data-test-subj': 'createNewTLSRule',
      icon: 'plusInCircle',
      onClick: () => {
        dispatch((0, _state.setAlertFlyoutVisible)({
          id: _synthetics_alerts.SYNTHETICS_TLS_RULE,
          isNewRuleFlyout: true
        }));
        setIsOpen(false);
      }
    }, {
      'aria-label': _translations.ToggleFlyoutTranslations.toggleMonitorStatusAriaLabel,
      'data-test-subj': 'editDefaultTlsRule',
      name: /*#__PURE__*/_react.default.createElement(_rule_name_with_loading.RuleNameWithLoading, {
        ruleName: EDIT_TLS_RULE_NAME,
        isLoading: loading,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 17
        }
      }),
      onClick: () => {
        dispatch((0, _state.setAlertFlyoutVisible)({
          id: _synthetics_alerts.SYNTHETICS_TLS_RULE,
          isNewRuleFlyout: false
        }));
        setIsOpen(false);
      },
      toolTipContent: !hasUptimeWrite ? noWritePermissionsTooltipContent : null,
      disabled: !hasUptimeWrite || loading,
      icon: 'bell'
    }]
  }];
  const alertFlyoutVisible = (0, _reactRedux.useSelector)(_state.selectAlertFlyoutVisibility);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
      color: "primary",
      "aria-label": _translations.ToggleFlyoutTranslations.toggleButtonAriaLabel,
      "data-test-subj": "syntheticsAlertsRulesButton",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => setIsOpen(!isOpen),
      disabled: !hasMonitors,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 11
      }
    }, _translations.ToggleFlyoutTranslations.alertsAndRules),
    closePopover: () => setIsOpen(false),
    isOpen: isOpen,
    ownFocus: true,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  })), alertFlyoutVisible && EditAlertFlyout, alertFlyoutVisible && NewRuleFlyout);
};
exports.ToggleAlertFlyoutButton = ToggleAlertFlyoutButton;
const noWritePermissionsTooltipContent = _i18n.i18n.translate('xpack.synthetics.alertDropdown.noPermissions', {
  defaultMessage: 'You do not have sufficient permissions to perform this action.'
});
const EDIT_TLS_RULE_NAME = exports.EDIT_TLS_RULE_NAME = _i18n.i18n.translate('xpack.synthetics.toggleTlsAlertButton.label.default', {
  defaultMessage: 'Edit default TLS rule'
});
const EDIT_STATUS_RULE = exports.EDIT_STATUS_RULE = _i18n.i18n.translate('xpack.synthetics.toggleStatusAlertButton.label.default', {
  defaultMessage: 'Edit default status rule'
});
const CREATE_TLS_RULE_NAME = exports.CREATE_TLS_RULE_NAME = _i18n.i18n.translate('xpack.synthetics.toggleTlsAlertButton.createRule', {
  defaultMessage: 'Create TLS rule'
});
const CREATE_STATUS_RULE = exports.CREATE_STATUS_RULE = _i18n.i18n.translate('xpack.synthetics.toggleStatusAlertButton.createRule', {
  defaultMessage: 'Create status rule'
});