"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.monitorDetailNavigatorParams = void 0;
var _common = require("@kbn/observability-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function navigate({
  configId,
  locationId,
  spaceId,
  timeRange,
  tabId
}) {
  let queryParam = locationId ? `?locationId=${locationId}` : '';
  const tab = `${tabId ? `/${tabId}` : ''}`;
  if (spaceId) {
    queryParam += queryParam ? `&spaceId=${spaceId}` : `?spaceId=${spaceId}`;
  }
  if (timeRange) {
    queryParam += queryParam ? `&dateRangeStart=${timeRange.from}&dateRangeEnd=${timeRange.to}` : `?dateRangeStart=${timeRange.from}&dateRangeEnd=${timeRange.to}`;
  }
  return {
    app: 'synthetics',
    path: `/monitor/${configId}${tab}${queryParam}`,
    state: {}
  };
}
const monitorDetailNavigatorParams = exports.monitorDetailNavigatorParams = {
  id: _common.syntheticsMonitorDetailLocatorID,
  getLocation: navigate
};