"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEnabledLifecycleFailureStore = exports.isEnabledFailureStore = exports.isDisabledLifecycleFailureStore = exports.failureStoreStatsSchema = exports.failureStoreSchema = exports.enabledWithLifecycleFailureStoreSchema = exports.enabledFailureStoreSchema = exports.effectiveFailureStoreSchema = void 0;
exports.isInheritFailureStore = isInheritFailureStore;
exports.wiredIngestStreamEffectiveFailureStoreSchema = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _type_guards = require("../../../shared/type_guards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inheritFailureStoreSchema = _zod.z.object({
  inherit: _zod.z.strictObject({})
});
const disabledFailureStoreSchema = _zod.z.object({
  disabled: _zod.z.strictObject({})
});
const enabledWithLifecycleFailureStoreSchema = exports.enabledWithLifecycleFailureStoreSchema = _zod.z.object({
  lifecycle: _zod.z.object({
    enabled: _zod.z.object({
      data_retention: _zodHelpers.NonEmptyString.optional()
    })
  })
});
const enabledWithoutLifecycleFailureStoreSchema = _zod.z.object({
  lifecycle: _zod.z.object({
    disabled: _zod.z.strictObject({})
  })
});
const effectiveFailureStoreSchema = exports.effectiveFailureStoreSchema = _zod.z.union([enabledWithLifecycleFailureStoreSchema, disabledFailureStoreSchema, enabledWithoutLifecycleFailureStoreSchema]);
const enabledFailureStoreSchema = exports.enabledFailureStoreSchema = _zod.z.union([enabledWithLifecycleFailureStoreSchema, enabledWithoutLifecycleFailureStoreSchema]);
const failureStoreSchema = exports.failureStoreSchema = _zod.z.union([inheritFailureStoreSchema, disabledFailureStoreSchema, enabledFailureStoreSchema]);
const failureStoreStatsSchema = exports.failureStoreStatsSchema = _zod.z.object({
  size: _zod.z.number().min(0).optional(),
  count: _zod.z.number().min(0).optional(),
  creationDate: _zod.z.number().min(0).optional()
});
const wiredIngestStreamEffectiveFailureStoreSchema = exports.wiredIngestStreamEffectiveFailureStoreSchema = _zod.z.union([enabledFailureStoreSchema, disabledFailureStoreSchema]).and(_zod.z.object({
  from: _zodHelpers.NonEmptyString
}));
const isEnabledLifecycleFailureStore = input => {
  return (0, _type_guards.isSchema)(enabledWithLifecycleFailureStoreSchema, input);
};
exports.isEnabledLifecycleFailureStore = isEnabledLifecycleFailureStore;
const isDisabledLifecycleFailureStore = input => {
  return (0, _type_guards.isSchema)(enabledWithoutLifecycleFailureStoreSchema, input);
};
exports.isDisabledLifecycleFailureStore = isDisabledLifecycleFailureStore;
const isEnabledFailureStore = input => {
  return (0, _type_guards.isSchema)(enabledFailureStoreSchema, input);
};
exports.isEnabledFailureStore = isEnabledFailureStore;
function isInheritFailureStore(input) {
  return (0, _type_guards.isSchema)(inheritFailureStoreSchema, input);
}