"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.effectiveToIngestLifecycle = effectiveToIngestLifecycle;
exports.findInheritedFailureStore = findInheritedFailureStore;
exports.findInheritedLifecycle = findInheritedLifecycle;
exports.findInheritingStreams = findInheritingStreams;
var _lifecycle = require("../models/ingest/lifecycle");
var _hierarchy = require("../shared/hierarchy");
var _failure_store = require("../models/ingest/failure_store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function findInheritedLifecycle(definition, ancestors) {
  const originDefinition = [...ancestors, definition].sort((a, b) => (0, _hierarchy.getSegments)(a.name).length - (0, _hierarchy.getSegments)(b.name).length).findLast(({
    ingest
  }) => !(0, _lifecycle.isInheritLifecycle)(ingest.lifecycle));
  if (!originDefinition) {
    throw new Error('Unable to find inherited lifecycle');
  }
  if ((0, _lifecycle.isInheritLifecycle)(originDefinition.ingest.lifecycle)) {
    throw new Error('Wired streams can only inherit DSL or ILM');
  }
  return {
    ...originDefinition.ingest.lifecycle,
    from: originDefinition.name
  };
}
function findInheritingStreams(root, descendants) {
  const inheriting = [];
  const queue = [root];
  while (queue.length > 0) {
    const definition = queue.shift();
    if ((0, _hierarchy.isDescendantOf)(root.name, definition.name) && !(0, _lifecycle.isInheritLifecycle)(definition.ingest.lifecycle)) {
      // ignore subtrees with a lifecycle override
      continue;
    }
    inheriting.push(definition.name);
    queue.push(...descendants.filter(child => (0, _hierarchy.isChildOf)(definition.name, child.name)));
  }
  return inheriting;
}
function effectiveToIngestLifecycle(effectiveLifecycle) {
  if ('from' in effectiveLifecycle) {
    const {
      from,
      ...lifecycle
    } = effectiveLifecycle;
    return lifecycle;
  }
  return effectiveLifecycle;
}
function findInheritedFailureStore(definition, ancestors) {
  const originDefinition = [...ancestors, definition].sort((a, b) => (0, _hierarchy.getSegments)(a.name).length - (0, _hierarchy.getSegments)(b.name).length).findLast(({
    ingest
  }) => !(0, _failure_store.isInheritFailureStore)(ingest.failure_store));
  if (!originDefinition) {
    throw new Error('Unable to find inherited failure store configuration');
  }
  if ((0, _failure_store.isInheritFailureStore)(originDefinition.ingest.failure_store)) {
    throw new Error('Wired streams can only inherit a defined failure store');
  }
  return {
    ...originDefinition.ingest.failure_store,
    from: originDefinition.name
  };
}