"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.featureWithFilterSchema = exports.featureTypeSchema = exports.featureSchema = exports.baseFeatureSchema = void 0;
exports.isFeatureWithFilter = isFeatureWithFilter;
exports.systemFeatureSchema = void 0;
var _streamlang = require("@kbn/streamlang");
var _zod = require("@kbn/zod");
var _stream_object_name = require("./shared/stream_object_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const featureTypes = ['system'];
const featureTypeSchema = exports.featureTypeSchema = _zod.z.enum(featureTypes);
const baseFeatureSchema = exports.baseFeatureSchema = _zod.z.object({
  type: featureTypeSchema,
  name: _stream_object_name.streamObjectNameSchema,
  description: _zod.z.string()
});
const featureWithFilterSchema = exports.featureWithFilterSchema = baseFeatureSchema.and(_zod.z.object({
  filter: _streamlang.conditionSchema
}));
const systemFeatureSchema = exports.systemFeatureSchema = featureWithFilterSchema.and(_zod.z.object({
  type: _zod.z.literal('system')
}));
const featureSchema = exports.featureSchema = systemFeatureSchema;
function isFeatureWithFilter(feature) {
  return 'filter' in feature && (0, _streamlang.isCondition)(feature.filter);
}