"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertSignificantEventsAccess = assertSignificantEventsAccess;
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _common = require("../../../common");
var _security_error = require("../../lib/streams/errors/security_error");
var _assert_enterprise_license = require("./assert_enterprise_license");
var _feature_not_enabled_error = require("../../lib/streams/errors/feature_not_enabled_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function assertSignificantEventsAccess({
  server,
  licensing,
  uiSettingsClient
}) {
  const isAvailableForTier = server.core.pricing.isFeatureAvailable(_common.STREAMS_TIERED_SIGNIFICANT_EVENT_FEATURE.id);
  if (!isAvailableForTier) {
    throw new _security_error.SecurityError(`Cannot access API on the current pricing tier`);
  }
  await Promise.all([(0, _assert_enterprise_license.assertEnterpriseLicense)(licensing), uiSettingsClient.get(_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_SIGNIFICANT_EVENTS).then(value => {
    if (!value) {
      throw new _feature_not_enabled_error.FeatureNotEnabledError(`Significant events is disabled. Enable ${_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_SIGNIFICANT_EVENTS} to start using it.`);
    }
  })]);
}