"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleProcessingGrokSuggestions = void 0;
exports.mapFields = mapFields;
exports.processingGrokSuggestionsSchema = void 0;
var _zod = require("@kbn/zod");
var _grokHeuristics = require("@kbn/grok-heuristics");
var _common_processing_helpers = require("./common_processing_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const processingGrokSuggestionsSchema = exports.processingGrokSuggestionsSchema = _zod.z.object({
  path: _zod.z.object({
    name: _zod.z.string()
  }),
  body: _zod.z.object({
    connector_id: _zod.z.string(),
    sample_messages: _zod.z.array(_zod.z.string()),
    review_fields: _zod.z.record(_zod.z.string(), _zod.z.object({
      grok_component: _zod.z.string(),
      example_values: _zod.z.array(_zod.z.string())
    }))
  })
});
const handleProcessingGrokSuggestions = async ({
  params,
  inferenceClient,
  streamsClient,
  fieldsMetadataClient,
  signal
}) => {
  // Determine if we should use OTEL field names
  const useOtelFieldNames = await (0, _common_processing_helpers.determineOtelFieldNameUsage)(streamsClient, params.path.name);

  // Call LLM inference to review fields
  const reviewResult = await (0, _common_processing_helpers.callInferenceWithPrompt)(inferenceClient, params.body.connector_id, _grokHeuristics.ReviewFieldsPrompt, params.body.sample_messages, params.body.review_fields, signal);

  // Fetch field metadata for ECS/OTEL field name resolution
  const fieldMetadata = await (0, _common_processing_helpers.fetchFieldMetadata)(fieldsMetadataClient, reviewResult.fields.map(field => field.ecs_field));
  return {
    log_source: reviewResult.log_source,
    fields: mapFields(reviewResult.fields, fieldMetadata, useOtelFieldNames)
  };
};
exports.handleProcessingGrokSuggestions = handleProcessingGrokSuggestions;
function mapFields(reviewResults, fieldMetadata, useOtelFieldNames) {
  return reviewResults.map(field => {
    const name = (0, _common_processing_helpers.normalizeFieldName)(field.ecs_field, fieldMetadata, useOtelFieldNames);
    return {
      name,
      columns: field.columns,
      grok_components: field.grok_components
    };
  });
}