"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleProcessingDissectSuggestions = void 0;
exports.mapFields = mapFields;
exports.processingDissectSuggestionsSchema = void 0;
var _zod = require("@kbn/zod");
var _dissectHeuristics = require("@kbn/dissect-heuristics");
var _common_processing_helpers = require("./common_processing_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const processingDissectSuggestionsSchema = exports.processingDissectSuggestionsSchema = _zod.z.object({
  path: _zod.z.object({
    name: _zod.z.string()
  }),
  body: _zod.z.object({
    connector_id: _zod.z.string(),
    sample_messages: _zod.z.array(_zod.z.string()),
    review_fields: _zod.z.record(_zod.z.string(), _zod.z.object({
      example_values: _zod.z.array(_zod.z.string()),
      position: _zod.z.number()
    }))
  })
});
const handleProcessingDissectSuggestions = async ({
  params,
  inferenceClient,
  streamsClient,
  fieldsMetadataClient,
  signal
}) => {
  // Determine if we should use OTEL field names
  const useOtelFieldNames = await (0, _common_processing_helpers.determineOtelFieldNameUsage)(streamsClient, params.path.name);

  // Call LLM inference to review fields
  const reviewResult = await (0, _common_processing_helpers.callInferenceWithPrompt)(inferenceClient, params.body.connector_id, _dissectHeuristics.ReviewDissectFieldsPrompt, params.body.sample_messages, params.body.review_fields, signal);

  // Fetch field metadata for ECS/OTEL field name resolution
  const fieldMetadata = await (0, _common_processing_helpers.fetchFieldMetadata)(fieldsMetadataClient, reviewResult.fields.map(field => field.ecs_field));
  return {
    log_source: reviewResult.log_source,
    fields: mapFields(reviewResult.fields, fieldMetadata, useOtelFieldNames)
  };
};
exports.handleProcessingDissectSuggestions = handleProcessingDissectSuggestions;
function mapFields(reviewResults, fieldMetadata, useOtelFieldNames) {
  return reviewResults.map(field => {
    const ecsField = (0, _common_processing_helpers.normalizeFieldName)(field.ecs_field, fieldMetadata, useOtelFieldNames);
    return {
      ecs_field: ecsField,
      columns: field.columns
    };
  });
}