"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.internalIngestRoutes = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../../../../../common/constants");
var _create_server_route = require("../../../create_server_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const processorSuggestionsRoute = (0, _create_server_route.createServerRoute)({
  endpoint: 'GET /internal/streams/ingest/processor_suggestions',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: [_constants.STREAMS_API_PRIVILEGES.read]
    }
  },
  params: _zod.z.object({}),
  handler: async ({
    processorSuggestions
  }) => {
    return processorSuggestions.getAllSuggestions();
  }
});
const internalIngestRoutes = exports.internalIngestRoutes = {
  ...processorSuggestionsRoute
};