"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.StreamsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _serverRouteRepository = require("@kbn/server-route-repository");
var _config = require("../common/config");
var _constants = require("../common/constants");
var _feature_flags = require("./feature_flags");
var _content_service = require("./lib/content/content_service");
var _register_rules = require("./lib/rules/register_rules");
var _asset_service = require("./lib/streams/assets/asset_service");
var _attachment_service = require("./lib/streams/attachments/attachment_service");
var _query_service = require("./lib/streams/assets/query/query_service");
var _service = require("./lib/streams/service");
var _telemetry = require("./lib/telemetry");
var _routes = require("./routes");
var _create_streams_global_search_result_provider = require("./lib/streams/create_streams_global_search_result_provider");
var _feature_service = require("./lib/streams/feature/feature_service");
var _processor_suggestions_service = require("./lib/streams/ingest_pipelines/processor_suggestions_service");
var _feature_type_registry = require("./lib/streams/feature/feature_type_registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

const config = exports.config = {
  schema: _config.configSchema,
  exposeToBrowser: _config.exposeToBrowserConfig
};
class StreamsPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "server", void 0);
    (0, _defineProperty2.default)(this, "isDev", void 0);
    (0, _defineProperty2.default)(this, "ebtTelemetryService", new _telemetry.EbtTelemetryService());
    (0, _defineProperty2.default)(this, "statsTelemetryService", new _telemetry.StatsTelemetryService());
    (0, _defineProperty2.default)(this, "processorSuggestionsService", void 0);
    this.isDev = context.env.mode.dev;
    this.config = context.config.get();
    this.logger = context.logger.get();
    this.processorSuggestionsService = new _processor_suggestions_service.ProcessorSuggestionsService();
  }
  setup(core, plugins) {
    this.server = {
      config: this.config,
      logger: this.logger
    };
    this.ebtTelemetryService.setup(core.analytics);
    this.statsTelemetryService.setup(core, this.logger.get('streams-stats-telemetry'), plugins.usageCollection);
    const alertingFeatures = _ruleDataUtils.STREAMS_RULE_TYPE_IDS.map(ruleTypeId => ({
      ruleTypeId,
      consumers: [_constants.STREAMS_CONSUMER]
    }));
    (0, _register_rules.registerRules)({
      plugins,
      logger: this.logger.get('rules')
    });
    const assetService = new _asset_service.AssetService(core, this.logger);
    const attachmentService = new _attachment_service.AttachmentService(core, this.logger);
    const streamsService = new _service.StreamsService(core, this.logger, this.isDev);
    const featureService = new _feature_service.FeatureService(core, this.logger, (0, _feature_type_registry.getDefaultFeatureRegistry)());
    const contentService = new _content_service.ContentService(core, this.logger);
    const queryService = new _query_service.QueryService(core, this.logger);
    plugins.features.registerKibanaFeature({
      id: _constants.STREAMS_FEATURE_ID,
      name: _i18n.i18n.translate('xpack.streams.featureRegistry.streamsFeatureName', {
        defaultMessage: 'Streams'
      }),
      order: 600,
      category: _server.DEFAULT_APP_CATEGORIES.management,
      app: [_constants.STREAMS_FEATURE_ID],
      privilegesTooltip: _i18n.i18n.translate('xpack.streams.featureRegistry.privilegesTooltip', {
        defaultMessage: 'All Spaces is required for Streams access.'
      }),
      alerting: alertingFeatures,
      privileges: {
        all: {
          app: [_constants.STREAMS_FEATURE_ID],
          savedObject: {
            all: [],
            read: []
          },
          requireAllSpaces: true,
          alerting: {
            rule: {
              all: alertingFeatures
            },
            alert: {
              all: alertingFeatures
            }
          },
          api: [_constants.STREAMS_API_PRIVILEGES.read, _constants.STREAMS_API_PRIVILEGES.manage],
          ui: [_constants.STREAMS_UI_PRIVILEGES.show, _constants.STREAMS_UI_PRIVILEGES.manage]
        },
        read: {
          app: [_constants.STREAMS_FEATURE_ID],
          savedObject: {
            all: [],
            read: []
          },
          requireAllSpaces: true,
          alerting: {
            rule: {
              read: alertingFeatures
            },
            alert: {
              read: alertingFeatures
            }
          },
          api: [_constants.STREAMS_API_PRIVILEGES.read],
          ui: [_constants.STREAMS_UI_PRIVILEGES.show]
        }
      }
    });
    core.pricing.registerProductFeatures(_constants.STREAMS_TIERED_FEATURES);
    (0, _serverRouteRepository.registerRoutes)({
      repository: _routes.streamsRouteRepository,
      dependencies: {
        assets: assetService,
        features: featureService,
        server: this.server,
        telemetry: this.ebtTelemetryService.getClient(),
        processorSuggestions: this.processorSuggestionsService,
        getScopedClients: async ({
          request
        }) => {
          const [[coreStart, pluginsStart], assetClient, attachmentClient, featureClient, contentClient] = await Promise.all([core.getStartServices(), assetService.getClientWithRequest({
            request
          }), attachmentService.getClientWithRequest({
            request
          }), featureService.getClientWithRequest({
            request
          }), contentService.getClient()]);
          const [queryClient, uiSettingsClient] = await Promise.all([queryService.getClientWithRequest({
            request,
            assetClient
          }), coreStart.uiSettings.asScopedToClient(coreStart.savedObjects.getScopedClient(request))]);
          const streamsClient = await streamsService.getClientWithRequest({
            request,
            assetClient,
            attachmentClient,
            queryClient,
            featureClient
          });
          const scopedClusterClient = coreStart.elasticsearch.client.asScoped(request);
          const soClient = coreStart.savedObjects.getScopedClient(request);
          const inferenceClient = pluginsStart.inference.getClient({
            request
          });
          const licensing = pluginsStart.licensing;
          const fieldsMetadataClient = await pluginsStart.fieldsMetadata.getClient(request);
          return {
            scopedClusterClient,
            soClient,
            assetClient,
            attachmentClient,
            streamsClient,
            featureClient,
            inferenceClient,
            contentClient,
            queryClient,
            fieldsMetadataClient,
            licensing,
            uiSettingsClient
          };
        }
      },
      core,
      logger: this.logger,
      runDevModeChecks: this.isDev
    });
    (0, _feature_flags.registerFeatureFlags)(core, this.logger);
    if (plugins.globalSearch) {
      plugins.globalSearch.registerResultProvider((0, _create_streams_global_search_result_provider.createStreamsGlobalSearchResultProvider)(core, this.logger));
    }
    return {};
  }
  start(core, plugins) {
    if (this.server) {
      this.server.core = core;
      this.server.isServerless = core.elasticsearch.getCapabilities().serverless;
      this.server.security = plugins.security;
      this.server.actions = plugins.actions;
      this.server.encryptedSavedObjects = plugins.encryptedSavedObjects;
      this.server.taskManager = plugins.taskManager;
    }
    this.processorSuggestionsService.setConsoleStart(plugins.console);
    return {};
  }
  stop() {}
}
exports.StreamsPlugin = StreamsPlugin;