"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerStreamsUsageCollector = registerStreamsUsageCollector;
var _schema = require("./schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Registers the Streams usage statistics collector with Kibana's usage collection service
 * This is reported under stack_stats as snapshot telemetry and collected once daily
 */
function registerStreamsUsageCollector(usageCollection, collectorOptions) {
  const streamsUsageCollector = usageCollection.makeUsageCollector({
    type: 'streams',
    isReady: collectorOptions.isReady,
    fetch: collectorOptions.fetch,
    schema: _schema.streamsStatsSchema
  });
  usageCollection.registerCollector(streamsUsageCollector);
}