"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStreamsStorageClient = createStreamsStorageClient;
var _storageAdapter = require("@kbn/storage-adapter");
var _migrate_on_read = require("./migrate_on_read");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const streamsStorageSettings = {
  name: '.kibana_streams',
  schema: {
    properties: {
      name: _storageAdapter.types.keyword(),
      description: _storageAdapter.types.text(),
      ingest: _storageAdapter.types.object({
        enabled: false
      }),
      group: _storageAdapter.types.object({
        enabled: false
      })
    }
  }
};
/**
 * This ensures there's only one way to initialize a storage client for streams, with the proper
 * settings and migration on read.
 * @param esClient
 * @param logger
 */
function createStreamsStorageClient(esClient, logger) {
  const adapter = new _storageAdapter.StorageIndexAdapter(esClient, logger, streamsStorageSettings, {
    migrateSource: _migrate_on_read.migrateOnRead
  });
  return adapter.getClient();
}