"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WiredStream = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _esErrors = require("@kbn/es-errors");
var _streamsSchema = require("@kbn/streams-schema");
var _lodash = _interopRequireWildcard(require("lodash"));
var _lifecycle = require("@kbn/streams-schema/src/helpers/lifecycle");
var _failure_store = require("@kbn/streams-schema/src/models/ingest/failure_store");
var _generate_layer = require("../../component_templates/generate_layer");
var _name = require("../../component_templates/name");
var _definition_not_found_error = require("../../errors/definition_not_found_error");
var _name_taken_error = require("../../errors/name_taken_error");
var _status_error = require("../../errors/status_error");
var _validate_fields = require("../../helpers/validate_fields");
var _validate_stream = require("../../helpers/validate_stream");
var _generate_index_template = require("../../index_templates/generate_index_template");
var _name2 = require("../../index_templates/name");
var _generate_ingest_pipeline = require("../../ingest_pipelines/generate_ingest_pipeline");
var _generate_reroute_pipeline = require("../../ingest_pipelines/generate_reroute_pipeline");
var _name3 = require("../../ingest_pipelines/name");
var _stream_active_record = require("../stream_active_record/stream_active_record");
var _root_stream_definition = require("../../root_stream_definition");
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WiredStream extends _stream_active_record.StreamActiveRecord {
  constructor(definition, dependencies) {
    super(definition, dependencies);
    (0, _defineProperty2.default)(this, "_changes", {
      ownFields: false,
      routing: false,
      processing: false,
      lifecycle: false,
      failure_store: false,
      settings: false
    });
  }
  doClone() {
    return new WiredStream((0, _lodash.cloneDeep)(this._definition), this.dependencies);
  }
  async doHandleUpsertChange(definition, desiredState, startingState) {
    var _startingState$get;
    if (definition.name !== this._definition.name) {
      // if the an ancestor stream gets upserted, we might need to update the stream - mark as upserted
      // so we check for updates during the Elasticsearch action planning phase.
      const ancestorHasChanged = _streamsSchema.Streams.WiredStream.Definition.is(definition) && (0, _streamsSchema.isDescendantOf)(definition.name, this._definition.name);
      return {
        changeStatus: ancestorHasChanged && !this.isDeleted() ? 'upserted' : this.changeStatus,
        cascadingChanges: []
      };
    }
    if (!_streamsSchema.Streams.WiredStream.Definition.is(definition)) {
      throw new _status_error.StatusError('Cannot change stream types', 400);
    }
    this._definition = definition;
    const startingStateStreamDefinition = (_startingState$get = startingState.get(this._definition.name)) === null || _startingState$get === void 0 ? void 0 : _startingState$get.definition;
    if (startingStateStreamDefinition && !_streamsSchema.Streams.WiredStream.Definition.is(startingStateStreamDefinition)) {
      throw new _status_error.StatusError('Unexpected starting state stream type', 400);
    }
    this._changes.ownFields = !startingStateStreamDefinition || !_lodash.default.isEqual(this._definition.ingest.wired.fields, startingStateStreamDefinition.ingest.wired.fields);
    this._changes.routing = !startingStateStreamDefinition || !_lodash.default.isEqual(this._definition.ingest.wired.routing, startingStateStreamDefinition.ingest.wired.routing);
    this._changes.failure_store = !startingStateStreamDefinition || !_lodash.default.isEqual(this._definition.ingest.failure_store, startingStateStreamDefinition.ingest.failure_store);
    this._changes.processing = !startingStateStreamDefinition || !_lodash.default.isEqual(this._definition.ingest.processing, startingStateStreamDefinition.ingest.processing);
    this._changes.lifecycle = !startingStateStreamDefinition || !_lodash.default.isEqual(this._definition.ingest.lifecycle, startingStateStreamDefinition.ingest.lifecycle);
    this._changes.settings = !startingStateStreamDefinition || !_lodash.default.isEqual(this._definition.ingest.settings, startingStateStreamDefinition.ingest.settings);
    const parentId = (0, _streamsSchema.getParentId)(this._definition.name);
    const cascadingChanges = [];
    if (parentId && !desiredState.has(parentId)) {
      cascadingChanges.push({
        type: 'upsert',
        definition: {
          name: parentId,
          description: '',
          ingest: {
            lifecycle: {
              inherit: {}
            },
            processing: {
              steps: []
            },
            settings: {},
            wired: {
              fields: {},
              routing: [{
                destination: this._definition.name,
                where: {
                  never: {}
                },
                status: 'disabled'
              }]
            },
            failure_store: {
              inherit: {}
            }
          }
        }
      });
    }
    if (this._changes.routing) {
      const routeTargets = this._definition.ingest.wired.routing.map(routing => routing.destination);
      for (const routeTarget of routeTargets) {
        if (!desiredState.has(routeTarget)) {
          cascadingChanges.push({
            type: 'upsert',
            definition: {
              name: routeTarget,
              description: '',
              ingest: {
                lifecycle: {
                  inherit: {}
                },
                processing: {
                  steps: []
                },
                settings: {},
                wired: {
                  fields: {},
                  routing: []
                },
                failure_store: {
                  inherit: {}
                }
              }
            }
          });
        }
      }
    }
    if (parentId && desiredState.has(parentId)) {
      const parentStream = desiredState.get(parentId);
      // if the parent hasn't changed already, ensure it has the correct routing
      // if it has changed, the routing will be updated in the parent's upsert
      if (!parentStream.hasChanged()) {
        const currentParentRouting = parentStream.definition.ingest.wired.routing;
        const hasChild = currentParentRouting.some(routing => routing.destination === this._definition.name);
        if (!hasChild) {
          cascadingChanges.push({
            type: 'upsert',
            definition: {
              name: parentId,
              description: '',
              ingest: {
                ...parentStream.definition.ingest,
                wired: {
                  ...parentStream.definition.ingest.wired,
                  routing: [...currentParentRouting, {
                    destination: this._definition.name,
                    where: {
                      never: {}
                    },
                    status: 'disabled'
                  }]
                }
              }
            }
          });
        }
      }
    }
    return {
      cascadingChanges,
      changeStatus: 'upserted'
    };
  }
  async doHandleDeleteChange(target, desiredState, startingState) {
    if (target !== this._definition.name) {
      return {
        cascadingChanges: [],
        changeStatus: this.changeStatus
      };
    }
    const cascadingChanges = [];
    const parentId = (0, _streamsSchema.getParentId)(this._definition.name);
    if (parentId) {
      const parentStream = desiredState.get(parentId);
      // if the parent hasn't changed already, ensure it has the correct routing
      // if it has changed, the routing will be updated in the parent's upsert
      if (!parentStream.hasChanged()) {
        const currentParentRouting = parentStream.definition.ingest.wired.routing;
        const hasChild = currentParentRouting.some(routing => routing.destination === this._definition.name);
        if (hasChild) {
          cascadingChanges.push({
            type: 'upsert',
            definition: {
              name: parentId,
              description: '',
              ingest: {
                ...parentStream.definition.ingest,
                wired: {
                  ...parentStream.definition.ingest.wired,
                  routing: parentStream.definition.ingest.wired.routing.filter(routing => routing.destination !== this._definition.name)
                }
              }
            }
          });
        }
      }
    }
    cascadingChanges.push(...this._definition.ingest.wired.routing.map(routing => ({
      name: routing.destination,
      type: 'delete'
    })));
    return {
      cascadingChanges,
      changeStatus: 'deleted'
    };
  }
  async doValidateUpsertion(desiredState, startingState) {
    if (!(0, _root_stream_definition.hasSupportedStreamsRoot)(this._definition.name)) {
      return {
        isValid: false,
        errors: [new Error('Cannot create wired stream due to unsupported root stream')]
      };
    }
    const nestingLevel = (0, _streamsSchema.getSegments)(this._definition.name).length;
    if (nestingLevel > _streamsSchema.MAX_NESTING_LEVEL) {
      return {
        isValid: false,
        errors: [new Error(`Cannot create wired stream "${this._definition.name}" due to nesting level exceeding ${_streamsSchema.MAX_NESTING_LEVEL}`)]
      };
    }
    const existsInStartingState = startingState.has(this._definition.name);
    if (this._changes.processing && this._definition.ingest.processing.steps.length > 0) {
      // recursively go through all steps to make sure it's not using manual_ingest_pipeline
      (0, _validate_stream.validateNoManualIngestPipelineUsage)(this._definition.ingest.processing.steps);
    }
    if (!existsInStartingState) {
      // Check for conflicts
      const {
        existsAsIndex,
        existsAsManagedDataStream,
        existsAsDataStream
      } = await this.getMatchingDataStream();
      if (existsAsIndex) {
        return {
          isValid: false,
          errors: [new Error(`Cannot create wired stream "${this._definition.name}" due to conflict caused by existing index`)]
        };
      }
      if (existsAsDataStream && !existsAsManagedDataStream) {
        // if the data stream exists, but is not managed by streams, we cannot create a wired stream with the same name
        return {
          isValid: false,
          errors: [new Error(`Cannot create wired stream "${this._definition.name}" due to conflict caused by existing data stream`)]
        };
      }
    }
    (0, _streamsSchema.getAncestors)(this._definition.name).forEach(name => {
      const ancestor = desiredState.get(name);
      if (!ancestor) {
        throw new Error(`ancestor ${name} not found is desired state`);
      }
    });

    // validate routing
    const children = new Set();
    for (const routing of this._definition.ingest.wired.routing) {
      if (children.has(routing.destination)) {
        return {
          isValid: false,
          errors: [new Error(`Child ${routing.destination} exists multiple times as child of ${this._definition.name}`)]
        };
      }
      if (!(0, _streamsSchema.isChildOf)(this._definition.name, routing.destination)) {
        return {
          isValid: false,
          errors: [new Error(`The ID of child stream ${routing.destination} must start with the parent's name (${this._definition.name}), followed by a dot and a name`)]
        };
      }
      children.add(routing.destination);
    }
    for (const stream of desiredState.all()) {
      if (!stream.isDeleted() && (0, _streamsSchema.isChildOf)(this._definition.name, stream.definition.name) && !children.has(stream.definition.name)) {
        return {
          isValid: false,
          errors: [new Error(`Child stream ${stream.definition.name} is not routed to from its parent ${this._definition.name}`)]
        };
      }
    }
    if (!existsInStartingState) {
      await this.assertNoHierarchicalConflicts(this._definition.name);
    }
    const ancestors = desiredState.all().filter(stream => {
      return (0, _streamsSchema.isDescendantOf)(stream.definition.name, this._definition.name);
    }).map(stream => stream.definition);
    const descendants = desiredState.all().filter(stream => {
      return (0, _streamsSchema.isDescendantOf)(this._definition.name, stream.definition.name);
    }).map(stream => stream.definition);
    (0, _validate_fields.validateAncestorFields)({
      ancestors,
      fields: this._definition.ingest.wired.fields
    });
    (0, _validate_fields.validateDescendantFields)({
      descendants,
      fields: this._definition.ingest.wired.fields
    });
    const startingStateRoot = startingState.get(this._definition.name);
    if ((0, _streamsSchema.isRootStreamDefinition)(this._definition) && startingStateRoot) {
      // only allow selective updates to a root stream
      _streamsSchema.Streams.WiredStream.Definition.asserts(startingStateRoot.definition);
      (0, _validate_stream.validateRootStreamChanges)(startingStateRoot.definition, this._definition);
    }
    (0, _validate_fields.validateSystemFields)(this._definition);
    (0, _validate_stream.validateBracketsInFieldNames)(this._definition);
    if (this.dependencies.isServerless) {
      if ((0, _streamsSchema.isIlmLifecycle)(this.getLifecycle())) {
        return {
          isValid: false,
          errors: [new Error('Using ILM is not supported in Serverless')]
        };
      }
      if ((0, _failure_store.isDisabledLifecycleFailureStore)(this.getFailureStore())) {
        return {
          isValid: false,
          errors: [new Error('Disabling failure store lifecycle is not supported in Serverless')]
        };
      }
    }
    (0, _validate_stream.validateSettings)(this._definition, this.dependencies.isServerless);
    return {
      isValid: true,
      errors: []
    };
  }
  async getMatchingDataStream() {
    try {
      var _response$data_stream;
      const response = await this.dependencies.scopedClusterClient.asCurrentUser.indices.getDataStream({
        name: this._definition.name
      });
      if (response.data_streams.length === 0) {
        // the request didn't throw an error, but the data stream doesn't exist
        // this means that the stream exists as an index, but not as a managed data stream
        return {
          existsAsIndex: true,
          existsAsManagedDataStream: false
        };
      }
      const existsAsManagedDataStream = response.data_streams.length === 1 && ((_response$data_stream = response.data_streams[0]._meta) === null || _response$data_stream === void 0 ? void 0 : _response$data_stream.managed_by) === 'streams';
      const existsAsDataStream = response.data_streams.length > 0;
      return {
        existsAsIndex: false,
        existsAsManagedDataStream,
        existsAsDataStream
      };
    } catch (error) {
      if (!(0, _esErrors.isNotFoundError)(error)) {
        throw error;
      }
      // not found error means that the data stream doesn't exist at all
      return {
        existsAsIndex: false,
        existsAsManagedDataStream: false,
        existsAsDataStream: false
      };
    }
  }
  async doValidateDeletion(desiredState, startingState) {
    return {
      isValid: true,
      errors: []
    };
  }
  async assertNoHierarchicalConflicts(definitionName) {
    const streamNames = (0, _streamsSchema.getAncestors)(definitionName);
    const hasConflict = await Promise.all(streamNames.map(streamName => this.isStreamNameTaken(streamName)));
    const conflicts = streamNames.filter((_val, index) => hasConflict[index]);
    if (conflicts.length !== 0) {
      throw new _name_taken_error.NameTakenError(`Cannot create stream "${definitionName}" due to hierarchical conflicts caused by existing classic stream definition, index or data stream: [${conflicts.join(', ')}]`);
    }
  }
  async isStreamNameTaken(name) {
    try {
      const definition = await this.dependencies.streamsClient.getStream(name);
      return _streamsSchema.Streams.ClassicStream.Definition.is(definition);
    } catch (error) {
      if (!(0, _definition_not_found_error.isDefinitionNotFoundError)(error)) {
        throw error;
      }
    }
    try {
      await this.dependencies.scopedClusterClient.asCurrentUser.indices.get({
        index: name
      });
      return true;
    } catch (error) {
      if ((0, _esErrors.isNotFoundError)(error)) {
        return false;
      }
      throw error;
    }
  }
  async doDetermineCreateActions(desiredState) {
    const ancestors = (0, _streamsSchema.getAncestorsAndSelf)(this._definition.name).map(id => desiredState.get(id).definition);
    const {
      from: _lifecycleOrigin,
      ...lifecycle
    } = (0, _streamsSchema.findInheritedLifecycle)(this._definition, ancestors);
    const {
      existsAsManagedDataStream
    } = await this.getMatchingDataStream();
    const settings = (0, _streamsSchema.getInheritedSettings)(ancestors);
    const {
      from: _fsOrigin,
      ...failureStore
    } = (0, _lifecycle.findInheritedFailureStore)(this._definition, ancestors);
    return [{
      type: 'upsert_component_template',
      request: (0, _generate_layer.generateLayer)(this._definition.name, this._definition, this.dependencies.isServerless)
    }, {
      type: 'upsert_ingest_pipeline',
      stream: this._definition.name,
      request: (0, _generate_ingest_pipeline.generateIngestPipeline)(this._definition.name, this._definition)
    }, {
      type: 'upsert_ingest_pipeline',
      stream: this._definition.name,
      request: (0, _generate_reroute_pipeline.generateReroutePipeline)({
        definition: this._definition
      })
    }, {
      type: 'upsert_index_template',
      request: (0, _generate_index_template.generateIndexTemplate)(this._definition.name)
    }, existsAsManagedDataStream ? {
      type: 'rollover',
      request: {
        name: this._definition.name
      }
    } : {
      type: 'upsert_datastream',
      request: {
        name: this._definition.name
      }
    }, {
      type: 'update_lifecycle',
      request: {
        name: this._definition.name,
        lifecycle
      }
    }, {
      type: 'update_ingest_settings',
      request: {
        name: this._definition.name,
        settings: (0, _helpers.formatSettings)(settings, this.dependencies.isServerless)
      }
    }, {
      type: 'update_failure_store',
      request: {
        name: this._definition.name,
        failure_store: failureStore,
        definition: this._definition
      }
    }, {
      type: 'upsert_dot_streams_document',
      request: this._definition
    }];
  }
  hasChangedFields() {
    return this._changes.ownFields;
  }
  hasChangedLifecycle() {
    return this._changes.lifecycle;
  }
  hasChangedFailureStore() {
    return this._changes.failure_store;
  }
  hasChangedSettings() {
    return this._changes.settings;
  }
  getLifecycle() {
    return this._definition.ingest.lifecycle;
  }
  getFailureStore() {
    return this._definition.ingest.failure_store;
  }
  async doDetermineUpdateActions(desiredState, startingState, startingStateStream) {
    const actions = [];
    if (this.hasChangedFields()) {
      actions.push({
        type: 'upsert_component_template',
        request: (0, _generate_layer.generateLayer)(this._definition.name, this._definition, this.dependencies.isServerless)
      });
    }
    const hasAncestorsWithChangedFields = (0, _streamsSchema.getAncestors)(this._definition.name).some(ancestor => {
      const ancestorStream = desiredState.get(ancestor);
      return ancestorStream.hasChangedFields();
    });
    if (this.hasChangedFields() || hasAncestorsWithChangedFields) {
      actions.push({
        type: 'rollover',
        request: {
          name: this._definition.name
        }
      });
    }
    if (this._changes.routing) {
      actions.push({
        type: 'upsert_ingest_pipeline',
        stream: this._definition.name,
        request: (0, _generate_reroute_pipeline.generateReroutePipeline)({
          definition: this._definition
        })
      });
    }
    if (this._changes.processing) {
      actions.push({
        type: 'upsert_ingest_pipeline',
        stream: this._definition.name,
        request: (0, _generate_ingest_pipeline.generateIngestPipeline)(this._definition.name, this._definition)
      });
    }
    const ancestorsAndSelf = (0, _streamsSchema.getAncestorsAndSelf)(this._definition.name).reverse();
    let hasAncestorWithChangedLifecycle = false;
    for (const ancestor of ancestorsAndSelf) {
      const ancestorStream = desiredState.get(ancestor);
      // as soon as at least one ancestor has an updated lifecycle, we need to update the lifecycle of the stream
      // once we find the ancestor actually defining the lifecycle
      if (ancestorStream.hasChangedLifecycle()) {
        hasAncestorWithChangedLifecycle = true;
      }
      // look for the first non-inherit lifecycle, that's the one defining the effective lifecycle
      if (!(0, _streamsSchema.isInheritLifecycle)(ancestorStream.getLifecycle())) {
        if (hasAncestorWithChangedLifecycle) {
          actions.push({
            type: 'update_lifecycle',
            request: {
              name: this._definition.name,
              lifecycle: ancestorStream.getLifecycle()
            }
          });
        }
        break;
      }
    }
    let hasAncestorWithChangedFailureStore = false;
    for (const ancestor of ancestorsAndSelf) {
      const ancestorStream = desiredState.get(ancestor);
      if (ancestorStream.hasChangedFailureStore()) {
        hasAncestorWithChangedFailureStore = true;
      }
      const ancestorFailureStore = ancestorStream.getFailureStore();
      if (!(0, _failure_store.isInheritFailureStore)(ancestorFailureStore)) {
        if (hasAncestorWithChangedFailureStore) {
          actions.push({
            type: 'update_failure_store',
            request: {
              name: this._definition.name,
              failure_store: ancestorFailureStore,
              definition: this._definition
            }
          });
        }
        break;
      }
    }
    const ancestors = (0, _streamsSchema.getAncestorsAndSelf)(this._definition.name).map(id => desiredState.get(id));
    if (ancestors.some(ancestor => ancestor.hasChangedSettings())) {
      const settings = (0, _streamsSchema.getInheritedSettings)(ancestors.map(ancestor => ancestor.definition));
      actions.push({
        type: 'update_ingest_settings',
        request: {
          name: this._definition.name,
          settings: (0, _helpers.formatSettings)(settings, this.dependencies.isServerless)
        }
      });
      const oldSettings = (0, _streamsSchema.getInheritedSettings)((0, _streamsSchema.getAncestorsAndSelf)(this._definition.name).map(id => startingState.get(id).definition));
      if ((0, _helpers.settingsUpdateRequiresRollover)(oldSettings, settings)) {
        actions.push({
          type: 'rollover',
          request: {
            name: this._definition.name
          }
        });
      }
    }
    const definitionChanged = !_lodash.default.isEqual(startingStateStream.definition, this._definition);
    if (definitionChanged) {
      actions.push({
        type: 'upsert_dot_streams_document',
        request: this._definition
      });
    }
    return actions;
  }
  async doDetermineDeleteActions() {
    return [{
      type: 'delete_index_template',
      request: {
        name: (0, _name2.getIndexTemplateName)(this._definition.name)
      }
    }, {
      type: 'delete_component_template',
      request: {
        name: (0, _name.getComponentTemplateName)(this._definition.name)
      }
    }, {
      type: 'delete_ingest_pipeline',
      request: {
        name: (0, _name3.getReroutePipelineName)(this._definition.name)
      }
    }, {
      type: 'delete_ingest_pipeline',
      request: {
        name: (0, _name3.getProcessingPipelineName)(this._definition.name)
      }
    }, {
      type: 'delete_datastream',
      request: {
        name: this._definition.name
      }
    }, {
      type: 'delete_dot_streams_document',
      request: {
        name: this._definition.name
      }
    }, {
      type: 'delete_queries',
      request: {
        name: this._definition.name
      }
    }, {
      type: 'unlink_assets',
      request: {
        name: this._definition.name
      }
    }, {
      type: 'unlink_features',
      request: {
        name: this._definition.name
      }
    }];
  }
}
exports.WiredStream = WiredStream;