"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatSettings = formatSettings;
exports.settingsUpdateRequiresRollover = settingsUpdateRequiresRollover;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatSettings(settings, isServerless) {
  var _settings$indexNumbe, _settings$indexNumbe2, _settings$indexNumbe3, _settings$indexNumbe4, _settings$indexRefre3, _settings$indexRefre4;
  if (isServerless) {
    var _settings$indexRefre, _settings$indexRefre2;
    return {
      'index.refresh_interval': (_settings$indexRefre = (_settings$indexRefre2 = settings['index.refresh_interval']) === null || _settings$indexRefre2 === void 0 ? void 0 : _settings$indexRefre2.value) !== null && _settings$indexRefre !== void 0 ? _settings$indexRefre : null
    };
  }
  return {
    'index.number_of_replicas': (_settings$indexNumbe = (_settings$indexNumbe2 = settings['index.number_of_replicas']) === null || _settings$indexNumbe2 === void 0 ? void 0 : _settings$indexNumbe2.value) !== null && _settings$indexNumbe !== void 0 ? _settings$indexNumbe : null,
    'index.number_of_shards': (_settings$indexNumbe3 = (_settings$indexNumbe4 = settings['index.number_of_shards']) === null || _settings$indexNumbe4 === void 0 ? void 0 : _settings$indexNumbe4.value) !== null && _settings$indexNumbe3 !== void 0 ? _settings$indexNumbe3 : null,
    'index.refresh_interval': (_settings$indexRefre3 = (_settings$indexRefre4 = settings['index.refresh_interval']) === null || _settings$indexRefre4 === void 0 ? void 0 : _settings$indexRefre4.value) !== null && _settings$indexRefre3 !== void 0 ? _settings$indexRefre3 : null
  };
}
function settingsUpdateRequiresRollover(oldSettings, newSettings) {
  var _oldSettings$indexNu, _newSettings$indexNu;
  return ((_oldSettings$indexNu = oldSettings['index.number_of_shards']) === null || _oldSettings$indexNu === void 0 ? void 0 : _oldSettings$indexNu.value) !== ((_newSettings$indexNu = newSettings['index.number_of_shards']) === null || _newSettings$indexNu === void 0 ? void 0 : _newSettings$indexNu.value);
}