"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsService = void 0;
var _lockManager = require("@kbn/lock-manager");
var _streams_storage_client = require("./storage/streams_storage_client");
var _client = require("./client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StreamsService {
  constructor(coreSetup, logger, isDev) {
    this.coreSetup = coreSetup;
    this.logger = logger;
    this.isDev = isDev;
  }
  async getClientWithRequest({
    request,
    assetClient,
    attachmentClient,
    queryClient,
    featureClient: featureClient
  }) {
    const [coreStart] = await this.coreSetup.getStartServices();
    const logger = this.logger;
    const scopedClusterClient = coreStart.elasticsearch.client.asScoped(request);
    const isServerless = coreStart.elasticsearch.getCapabilities().serverless;
    return new _client.StreamsClient({
      assetClient,
      attachmentClient,
      queryClient,
      featureClient,
      logger,
      scopedClusterClient,
      lockManager: new _lockManager.LockManagerService(this.coreSetup, logger),
      storageClient: (0, _streams_storage_client.createStreamsStorageClient)(scopedClusterClient.asInternalUser, logger),
      request,
      isServerless,
      isDev: this.isDev
    });
  }
}
exports.StreamsService = StreamsService;