"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTemplateFromRule = getTemplateFromRule;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isRuleObject(value) {
  return typeof value === 'object' && value !== null;
}
function getTemplateFromRule(rule) {
  if (rule === null) return null;
  const t = typeof rule;
  if (t === 'string' || t === 'number' || t === 'boolean') {
    return rule;
  }
  if (Array.isArray(rule)) {
    if (rule.length === 1 && rule[0] && typeof rule[0] === 'object' && !Array.isArray(rule[0])) {
      const inner = getTemplateFromRule(rule[0]);
      return inner != null ? [inner] : [];
    }
    return [];
  }
  if (isRuleObject(rule)) {
    if (rule.__template !== undefined) {
      return rule.__template;
    }
    if (Array.isArray(rule.__one_of) && rule.__one_of.length > 0) {
      return getTemplateFromRule(rule.__one_of[0]);
    }
    if ('__any_of' in rule) {
      return [];
    }
    if ('__scope_link' in rule) {
      return {};
    }
    return {};
  }
  return undefined;
}