"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.featureStorageSettings = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
var _fields = require("./fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const featureStorageSettings = exports.featureStorageSettings = {
  // Initially features were called systems, for backward compatibility we need to keep the same index name
  name: '.kibana_streams_systems',
  schema: {
    properties: {
      [_fields.FEATURE_UUID]: _storageAdapter.types.keyword(),
      [_fields.STREAM_NAME]: _storageAdapter.types.keyword(),
      [_fields.FEATURE_TYPE]: _storageAdapter.types.keyword(),
      [_fields.FEATURE_NAME]: _storageAdapter.types.keyword(),
      [_fields.FEATURE_DESCRIPTION]: _storageAdapter.types.text(),
      [_fields.FEATURE_FILTER]: _storageAdapter.types.object({
        enabled: false
      })
    }
  }
};