"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemFeatureHandler = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectHash = _interopRequireDefault(require("object-hash"));
var _streamsAi = require("@kbn/streams-ai");
var _feature_type_handler = require("../feature_type_handler");
var _fields = require("../fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SystemFeatureHandler extends _feature_type_handler.FeatureTypeHandler {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "type", 'system');
  }
  fromStorage(stored) {
    return {
      type: stored[_fields.FEATURE_TYPE],
      name: stored[_fields.FEATURE_NAME],
      description: stored[_fields.FEATURE_DESCRIPTION],
      filter: stored[_fields.FEATURE_FILTER]
    };
  }
  toStorage(streamName, feature) {
    return {
      [_fields.STREAM_NAME]: streamName,
      [_fields.FEATURE_UUID]: this.getFeatureUuid(streamName, feature.name),
      [_fields.FEATURE_TYPE]: feature.type,
      [_fields.FEATURE_NAME]: feature.name,
      [_fields.FEATURE_DESCRIPTION]: feature.description,
      [_fields.FEATURE_FILTER]: feature.filter
    };
  }
  identifyFeatures(options) {
    return (0, _streamsAi.identifySystemFeatures)({
      ...options,
      dropUnmapped: true
    });
  }
  getFeatureUuid(streamName, featureName) {
    // override required for bwc
    return (0, _objectHash.default)({
      [_fields.STREAM_NAME]: streamName,
      [_fields.FEATURE_NAME]: featureName
    });
  }
}
exports.SystemFeatureHandler = SystemFeatureHandler;