"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureTypeRegistry = void 0;
exports.getDefaultFeatureRegistry = getDefaultFeatureRegistry;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _aiTools = require("@kbn/ai-tools");
var _system = require("./handlers/system");
var _fields = require("./fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FeatureTypeRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "handlers", new Map());
  }
  register(handler) {
    if (this.handlers.has(handler.type)) {
      throw new Error(`Feature type handler for type "${handler.type}" is already registered`);
    }
    this.handlers.set(handler.type, handler);
  }
  unregister(type) {
    return this.handlers.delete(type);
  }
  getHandler(type) {
    const handler = this.handlers.get(type);
    if (!handler) {
      throw new Error(`No feature type handler registered for type "${type}"`);
    }
    return handler;
  }
  hasHandler(type) {
    return this.handlers.has(type);
  }
  getRegisteredTypes() {
    return Array.from(this.handlers.keys());
  }
  fromStorage(stored) {
    const type = stored[_fields.FEATURE_TYPE];
    const handler = this.getHandler(type);
    return handler.fromStorage(stored);
  }
  toStorage(streamName, feature) {
    const handler = this.getHandler(feature.type);
    return handler.toStorage(streamName, feature);
  }
  async identifyFeatures(options) {
    const analysis = await (0, _aiTools.describeDataset)({
      start: options.start,
      end: options.end,
      esClient: options.esClient,
      index: options.stream.name
    });
    const features = [];
    for (const handler of this.handlers.values()) {
      const result = await handler.identifyFeatures({
        ...options,
        analysis
      });
      features.push(...result.features);
    }
    return {
      features
    };
  }
}
exports.FeatureTypeRegistry = FeatureTypeRegistry;
const defaultRegistry = new FeatureTypeRegistry();
defaultRegistry.register(new _system.SystemFeatureHandler());
function getDefaultFeatureRegistry() {
  return defaultRegistry;
}