"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureTypeHandler = void 0;
var _objectHash = _interopRequireDefault(require("object-hash"));
var _fields = require("./fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FeatureTypeHandler {
  getFeatureUuid(streamName, featureName) {
    return (0, _objectHash.default)({
      [_fields.FEATURE_TYPE]: this.type,
      [_fields.STREAM_NAME]: streamName,
      [_fields.FEATURE_NAME]: featureName
    });
  }
}
exports.FeatureTypeHandler = FeatureTypeHandler;