"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureService = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
var _feature_client = require("./feature_client");
var _stored_feature = require("./stored_feature");
var _storage_settings = require("./storage_settings");
var _fields = require("./fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FeatureService {
  constructor(coreSetup, logger, featureRegistry) {
    this.coreSetup = coreSetup;
    this.logger = logger;
    this.featureRegistry = featureRegistry;
  }
  async getClientWithRequest({
    request
  }) {
    const [coreStart] = await this.coreSetup.getStartServices();
    const adapter = new _storageAdapter.StorageIndexAdapter(coreStart.elasticsearch.client.asInternalUser, this.logger.get('features'), _storage_settings.featureStorageSettings, {
      migrateSource: feature => {
        if (!(_fields.FEATURE_TYPE in feature)) {
          const migrated = {
            ...feature,
            [_fields.FEATURE_TYPE]: 'system'
          };
          _stored_feature.storedFeatureSchema.parse(migrated);
          return migrated;
        }
        return feature;
      }
    });
    return new _feature_client.FeatureClient({
      storageClient: adapter.getClient()
    }, this.featureRegistry);
  }
}
exports.FeatureService = FeatureService;