"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttachmentDocument = void 0;
exports.getAttachmentLinkUuid = getAttachmentLinkUuid;
exports.getSuggestedSo = exports.getSoByIds = void 0;
var _objectHash = _interopRequireDefault(require("object-hash"));
var _storage_settings = require("./storage_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAttachmentLinkUuid(attachment) {
  return (0, _objectHash.default)({
    [_storage_settings.ATTACHMENT_ID]: attachment.id,
    [_storage_settings.ATTACHMENT_TYPE]: attachment.type
  });
}
const getAttachmentDocument = attachment => {
  return {
    [_storage_settings.ATTACHMENT_ID]: attachment.id,
    [_storage_settings.ATTACHMENT_TYPE]: attachment.type,
    [_storage_settings.ATTACHMENT_UUID]: attachment.uuid,
    [_storage_settings.STREAM_NAMES]: attachment.streamNames
  };
};
exports.getAttachmentDocument = getAttachmentDocument;
const soToAttachment = (savedObject, attachmentType) => {
  return {
    id: savedObject.id,
    type: attachmentType,
    title: savedObject.attributes.title,
    tags: savedObject.references.filter(ref => ref.type === 'tag').map(ref => ref.id)
  };
};
const getSoByIds = async ({
  soClient,
  attachmentType,
  ids
}) => {
  const result = await soClient.bulkGet(ids.map(id => ({
    id,
    type: attachmentType
  })));
  return result.saved_objects.filter(savedObject => !savedObject.error).map(savedObject => soToAttachment(savedObject, attachmentType));
};
exports.getSoByIds = getSoByIds;
const getSuggestedSo = async ({
  soClient,
  attachmentType,
  query,
  tags,
  perPage
}) => {
  const result = await soClient.find({
    type: attachmentType,
    search: query,
    perPage,
    ...(tags ? {
      hasReferenceOperator: 'OR',
      hasReference: tags.map(tag => ({
        type: 'tag',
        id: tag
      }))
    } : {})
  });
  return result.saved_objects.filter(savedObject => !savedObject.error).map(savedObject => soToAttachment(savedObject, attachmentType));
};
exports.getSuggestedSo = getSuggestedSo;