"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.attachmentStorageSettings = exports.STREAM_NAMES = exports.ATTACHMENT_UUID = exports.ATTACHMENT_TYPE = exports.ATTACHMENT_ID = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STREAM_NAMES = exports.STREAM_NAMES = 'stream.names';
const ATTACHMENT_UUID = exports.ATTACHMENT_UUID = 'attachment.uuid';
const ATTACHMENT_ID = exports.ATTACHMENT_ID = 'attachment.id';
const ATTACHMENT_TYPE = exports.ATTACHMENT_TYPE = 'attachment.type';
const attachmentStorageSettings = exports.attachmentStorageSettings = {
  name: '.kibana_streams_attachments',
  schema: {
    properties: {
      [ATTACHMENT_UUID]: _storageAdapter.types.keyword(),
      [ATTACHMENT_ID]: _storageAdapter.types.keyword(),
      [ATTACHMENT_TYPE]: _storageAdapter.types.keyword(),
      [STREAM_NAMES]: _storageAdapter.types.keyword()
    }
  }
};