"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttachmentService = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
var _attachment_client = require("./attachment_client");
var _storage_settings = require("./storage_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AttachmentService {
  constructor(coreSetup, logger) {
    this.coreSetup = coreSetup;
    this.logger = logger;
  }
  async getClientWithRequest({
    request
  }) {
    const [coreStart, pluginsStart] = await this.coreSetup.getStartServices();
    const adapter = new _storageAdapter.StorageIndexAdapter(coreStart.elasticsearch.client.asInternalUser, this.logger.get('attachments'), _storage_settings.attachmentStorageSettings);
    return new _attachment_client.AttachmentClient({
      storageClient: adapter.getClient(),
      soClient: coreStart.savedObjects.getScopedClient(request),
      rulesClient: await pluginsStart.alerting.getRulesClientWithRequest(request)
    });
  }
}
exports.AttachmentService = AttachmentService;