"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assignShortIds = assignShortIds;
var _inferenceCommon = require("@kbn/inference-common");
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function assignShortIds(verifiedQueries) {
  const idLookupTable = new _inferenceCommon.ShortIdTable();
  const queriesWithShortIds = verifiedQueries.queries.map(query => {
    const id = (0, _uuid.v4)();
    const shortId = idLookupTable.take(id);
    return {
      id,
      shortId,
      ...query
    };
  });
  const queriesByShortId = new Map(queriesWithShortIds.map(({
    shortId,
    ...query
  }) => [shortId, query]));
  return {
    queriesWithShortIds,
    queriesByShortId
  };
}