"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.analyzeDataset = analyzeDataset;
var _aiTools = require("@kbn/ai-tools");
var _streamsSchema = require("@kbn/streams-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function analyzeDataset(params, dependencies) {
  const {
    esClient
  } = dependencies;
  const {
    start,
    end,
    definition
  } = params;
  const analysis = await (0, _aiTools.describeDataset)({
    esClient: esClient.client,
    start,
    end,
    index: (0, _streamsSchema.getIndexPatternsForStream)(definition)
  });
  const short = (0, _aiTools.formatDocumentAnalysis)(analysis);
  const textFields = analysis.fields.filter(field => field.types.includes('text')).map(field => field.name);
  const categorizationField = textFields.includes('message') ? 'message' : textFields.includes('body.text') ? 'body.text' : undefined;
  return {
    categorizationField,
    short
  };
}