"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateSignificantEventDefinitions = generateSignificantEventDefinitions;
var _streamsAi = require("@kbn/streams-ai");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function generateSignificantEventDefinitions(params, dependencies) {
  const {
    definition,
    connectorId,
    start,
    end,
    feature
  } = params;
  const {
    inferenceClient,
    esClient,
    logger,
    signal
  } = dependencies;
  const boundInferenceClient = inferenceClient.bindTo({
    connectorId
  });
  const {
    queries
  } = await (0, _streamsAi.generateSignificantEvents)({
    stream: definition,
    start,
    end,
    esClient,
    inferenceClient: boundInferenceClient,
    logger,
    feature,
    signal
  });
  return queries.map(query => ({
    title: query.title,
    kql: query.kql,
    feature: feature ? {
      name: feature.name,
      filter: feature === null || feature === void 0 ? void 0 : feature.filter
    } : undefined
  }));
}