"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleExecutor = getRuleExecutor;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _objectHash = _interopRequireDefault(require("object-hash"));
var _common = require("./common");
var _build_esql_search_request = require("./lib/build_esql_search_request");
var _execute_esql_request = require("./lib/execute_esql_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getRuleExecutor(options) {
  var _state$previousOrigin;
  const {
    services,
    params,
    logger,
    state,
    startedAt,
    spaceId,
    rule
  } = options;
  const {
    scopedClusterClient,
    alertWithPersistence
  } = services;
  const previousOriginalDocumentIds = (_state$previousOrigin = state.previousOriginalDocumentIds) !== null && _state$previousOrigin !== void 0 ? _state$previousOrigin : [];
  const now = (0, _moment.default)(startedAt);
  const esqlRequest = (0, _build_esql_search_request.buildEsqlSearchRequest)({
    query: params.query,
    timestampField: params.timestampField,
    from: now.clone().subtract(2, 'minutes').toISOString(),
    to: now.clone().toISOString(),
    previousOriginalDocumentIds
  });
  const results = await (0, _execute_esql_request.executeEsqlRequest)({
    esClient: scopedClusterClient.asCurrentUser,
    esqlRequest,
    logger
  });
  const alertDocIdToDocumentIdMap = new Map();
  const alerts = results.map(result => {
    const alertDocId = (0, _objectHash.default)([result._id, rule.id, spaceId]);
    alertDocIdToDocumentIdMap.set(alertDocId, result._id);
    return {
      _id: alertDocId,
      _source: {
        original_source: {
          _id: result._id,
          ...result._source
        }
      }
    };
  });
  const {
    createdAlerts,
    errors
  } = await alertWithPersistence(alerts, true, _common.MAX_ALERTS_PER_EXECUTION);
  if (!(0, _lodash.isEmpty)(errors)) {
    logger.debug(() => `Alerts bulk process finished with errors: ${JSON.stringify(errors)}`);
  }
  const originalDocumentIds = createdAlerts.map(alert => alertDocIdToDocumentIdMap.get(alert._id));
  return {
    state: {
      previousOriginalDocumentIds: originalDocumentIds
    }
  };
}