"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverRouteRepositoryClient = require("@kbn/server-route-repository-client");
var _rxjs = require("rxjs");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Plugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "repositoryClient", void 0);
    (0, _defineProperty2.default)(this, "isServerless", void 0);
    this.config = context.config.get();
    this.isServerless = context.env.packageInfo.buildFlavor === 'serverless';
    this.logger = context.logger.get();
  }
  setup(core, pluginSetup) {
    this.repositoryClient = (0, _serverRouteRepositoryClient.createRepositoryClient)(core);
    return {};
  }
  start(core, pluginsStart) {
    return {
      streamsRepositoryClient: this.repositoryClient,
      navigationStatus$: createStreamsNavigationStatusObservable(pluginsStart, core.application, this.isServerless),
      getWiredStatus: async () => {
        try {
          return await this.repositoryClient.fetch('GET /api/streams/_status', {
            signal: new AbortController().signal
          });
        } catch (error) {
          this.logger.error(error);
          return UNKNOWN_STATUS;
        }
      },
      enableWiredMode: async signal => {
        return await this.repositoryClient.fetch('POST /api/streams/_enable 2023-10-31', {
          signal
        });
      },
      disableWiredMode: async signal => {
        return await this.repositoryClient.fetch('POST /api/streams/_disable 2023-10-31', {
          signal
        });
      },
      config$: (0, _rxjs.of)(this.config)
    };
  }
  stop() {}
}
exports.Plugin = Plugin;
const UNKNOWN_STATUS = {
  enabled: 'unknown',
  can_manage: false
};
const createStreamsNavigationStatusObservable = (0, _lodash.once)((deps, application, isServerless) => {
  var _application$capabili, _application$capabili2, _deps$cloud, _deps$cloud2, _deps$spaces;
  const hasCapabilities = (_application$capabili = application.capabilities) === null || _application$capabili === void 0 ? void 0 : (_application$capabili2 = _application$capabili.streams) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.show;
  const isServerlessObservability = ((_deps$cloud = deps.cloud) === null || _deps$cloud === void 0 ? void 0 : _deps$cloud.serverless.projectType) === 'observability';
  const isServerlessSecurity = ((_deps$cloud2 = deps.cloud) === null || _deps$cloud2 === void 0 ? void 0 : _deps$cloud2.serverless.projectType) === 'security';
  if (!hasCapabilities) {
    return (0, _rxjs.of)({
      status: 'disabled'
    });
  }
  if (isServerless) {
    // For serverless, only check cloud project type
    return (0, _rxjs.of)({
      status: isServerlessObservability || isServerlessSecurity ? 'enabled' : 'disabled'
    });
  }

  // For non-serverless, check the active space solution
  if (!((_deps$spaces = deps.spaces) !== null && _deps$spaces !== void 0 && _deps$spaces.getActiveSpace)) {
    return (0, _rxjs.of)({
      status: 'enabled'
    });
  }
  return (0, _rxjs.from)(deps.spaces.getActiveSpace()).pipe((0, _rxjs.map)(space => {
    const spaceSolution = space === null || space === void 0 ? void 0 : space.solution;
    const isValidSolution = !spaceSolution || spaceSolution === 'classic' || spaceSolution === 'oblt' || spaceSolution === 'security';
    return {
      status: isValidSolution ? 'enabled' : 'disabled'
    };
  }), (0, _rxjs.catchError)(() => {
    return (0, _rxjs.of)({
      status: 'enabled'
    });
  }));
});