"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEsqlFilter = buildEsqlFilter;
exports.excludeFrozenQuery = excludeFrozenQuery;
exports.isKqlQueryValid = isKqlQueryValid;
exports.kqlQuery = kqlQuery;
exports.rangeQuery = rangeQuery;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function excludeTiersQuery(excludedDataTiers) {
  return [{
    bool: {
      must_not: [{
        terms: {
          _tier: excludedDataTiers
        }
      }]
    }
  }];
}
function excludeFrozenQuery() {
  return excludeTiersQuery(['data_frozen']);
}
function kqlQuery(kql) {
  if (!kql) {
    return [];
  }
  const ast = (0, _esQuery.fromKueryExpression)(kql);
  return [(0, _esQuery.toElasticsearchQuery)(ast)];
}
function rangeQuery(start, end, field = '@timestamp') {
  return [{
    range: {
      [field]: {
        gte: start,
        lte: end,
        format: 'epoch_millis'
      }
    }
  }];
}
function isKqlQueryValid(kql) {
  if (!kql) {
    return false;
  }
  try {
    (0, _esQuery.fromKueryExpression)(kql);
    return true;
  } catch (error) {
    return false;
  }
}

/**
 * Builds a combined filter for ES|QL queries following the same pattern
 * as the server-side route used to apply.
 */
function buildEsqlFilter({
  filter,
  kuery,
  start,
  end
}) {
  const filters = [filter || {
    match_all: {}
  }, ...kqlQuery(kuery), ...excludeFrozenQuery()];
  if (start !== undefined && end !== undefined) {
    filters.push(...rangeQuery(start, end));
  }
  return {
    bool: {
      filter: filters
    }
  };
}