"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wiredStreamsStatusChangedSchema = exports.streamsSignificantEventsSuggestionsGeneratedSchema = exports.streamsSignificantEventsCreatedSchema = exports.streamsSchemaUpdatedSchema = exports.streamsRetentionChangedSchema = exports.streamsProcessingSavedSchema = exports.streamsChildStreamCreatedSchema = exports.streamsAttachmentCountSchema = exports.streamsAttachmentClickEventSchema = exports.streamsAIGrokSuggestionLatencySchema = exports.streamsAIGrokSuggestionAcceptedSchema = exports.streamsAIDissectSuggestionLatencySchema = exports.streamsAIDissectSuggestionAcceptedSchema = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const streamsAttachmentCountSchema = exports.streamsAttachmentCountSchema = {
  name: {
    type: 'keyword',
    _meta: {
      description: 'The name of the Stream'
    }
  },
  dashboards: {
    type: 'long',
    _meta: {
      description: 'The duration of the endpoint in milliseconds'
    }
  },
  slos: {
    type: 'long',
    _meta: {
      description: 'The duration of the endpoint in milliseconds',
      optional: true
    }
  },
  rules: {
    type: 'long',
    _meta: {
      description: 'The duration of the endpoint in milliseconds',
      optional: true
    }
  }
};
const streamsAttachmentClickEventSchema = exports.streamsAttachmentClickEventSchema = {
  name: {
    type: 'keyword',
    _meta: {
      description: 'The name of the Stream'
    }
  },
  attachment_type: {
    type: 'keyword',
    _meta: {
      description: 'The type of attachment: dashboard, slo, rule'
    }
  },
  attachment_id: {
    type: 'keyword',
    _meta: {
      description: 'The id of the attachment'
    }
  }
};
const matchRate = {
  type: 'array',
  items: {
    type: 'float',
    _meta: {
      description: 'The rate'
    }
  },
  _meta: {
    description: 'The success rate of each match'
  }
};
const streamsAIGrokSuggestionLatencySchema = exports.streamsAIGrokSuggestionLatencySchema = {
  name: {
    type: 'keyword',
    _meta: {
      description: 'The name of the Stream'
    }
  },
  field: {
    type: 'keyword',
    _meta: {
      description: 'The name of the field used.'
    }
  },
  connector_id: {
    type: 'keyword',
    _meta: {
      description: 'The ID of the LLM connector'
    }
  },
  suggestion_count: {
    type: 'long',
    _meta: {
      description: 'The number of suggestions in the response'
    }
  },
  match_rate: matchRate,
  duration_ms: {
    type: 'long',
    _meta: {
      description: 'The duration of the request'
    }
  }
};
const streamsAIGrokSuggestionAcceptedSchema = exports.streamsAIGrokSuggestionAcceptedSchema = {
  name: {
    type: 'keyword',
    _meta: {
      description: 'The name of the Stream'
    }
  },
  field: {
    type: 'keyword',
    _meta: {
      description: 'The name of the field used.'
    }
  },
  connector_id: {
    type: 'keyword',
    _meta: {
      description: 'The ID of the LLM connector'
    }
  },
  match_rate: {
    type: 'float',
    _meta: {
      description: 'The success rate of suggestion'
    }
  },
  detected_fields: {
    type: 'long',
    _meta: {
      description: 'The number of detected fields'
    }
  }
};
const streamsAIDissectSuggestionLatencySchema = exports.streamsAIDissectSuggestionLatencySchema = {
  name: {
    type: 'keyword',
    _meta: {
      description: 'The name of the Stream'
    }
  },
  field: {
    type: 'keyword',
    _meta: {
      description: 'The name of the field used.'
    }
  },
  connector_id: {
    type: 'keyword',
    _meta: {
      description: 'The ID of the LLM connector'
    }
  },
  suggestion_count: {
    type: 'long',
    _meta: {
      description: 'The number of suggestions in the response'
    }
  },
  match_rate: matchRate,
  duration_ms: {
    type: 'long',
    _meta: {
      description: 'The duration of the request'
    }
  }
};
const streamsAIDissectSuggestionAcceptedSchema = exports.streamsAIDissectSuggestionAcceptedSchema = {
  name: {
    type: 'keyword',
    _meta: {
      description: 'The name of the Stream'
    }
  },
  field: {
    type: 'keyword',
    _meta: {
      description: 'The name of the field used.'
    }
  },
  connector_id: {
    type: 'keyword',
    _meta: {
      description: 'The ID of the LLM connector'
    }
  },
  match_rate: {
    type: 'float',
    _meta: {
      description: 'The success rate of suggestion'
    }
  },
  detected_fields: {
    type: 'long',
    _meta: {
      description: 'The number of detected fields'
    }
  }
};
const wiredStreamsStatusChangedSchema = exports.wiredStreamsStatusChangedSchema = {
  is_enabled: {
    type: 'boolean',
    _meta: {
      description: 'Whether wired streams was enabled or disabled'
    }
  }
};
const streamsProcessingSavedSchema = exports.streamsProcessingSavedSchema = {
  processors_count: {
    type: 'long',
    _meta: {
      description: 'The number of processors configured on the stream'
    }
  },
  stream_type: {
    type: 'keyword',
    _meta: {
      description: 'The type of the stream: wired or classic'
    }
  }
};
const streamsRetentionChangedSchema = exports.streamsRetentionChangedSchema = {
  lifecycle_type: {
    type: 'keyword',
    _meta: {
      description: 'The type of lifecycle: dsl, ilm, inherit'
    }
  },
  lifecycle_value: {
    type: 'keyword',
    _meta: {
      description: 'The lifecycle value, if applicable',
      optional: true
    }
  },
  stream_type: {
    type: 'keyword',
    _meta: {
      description: 'The type of the stream: wired or classic'
    }
  }
};
const streamsChildStreamCreatedSchema = exports.streamsChildStreamCreatedSchema = {
  name: {
    type: 'keyword',
    _meta: {
      description: 'The name of the child stream'
    }
  }
};
const streamsSchemaUpdatedSchema = exports.streamsSchemaUpdatedSchema = {
  stream_type: {
    type: 'keyword',
    _meta: {
      description: 'The type of the stream: wired or classic'
    }
  }
};
const streamsSignificantEventsSuggestionsGeneratedSchema = exports.streamsSignificantEventsSuggestionsGeneratedSchema = {
  duration_ms: {
    type: 'long',
    _meta: {
      description: 'The time (in milliseconds) it took to generate significant events suggestions'
    }
  },
  stream_type: {
    type: 'keyword',
    _meta: {
      description: 'The type of the stream: wired or classic'
    }
  }
};
const streamsSignificantEventsCreatedSchema = exports.streamsSignificantEventsCreatedSchema = {
  count: {
    type: 'long',
    _meta: {
      description: 'The number of significant events created'
    }
  },
  stream_type: {
    type: 'keyword',
    _meta: {
      description: 'The type of the stream: wired or classic'
    }
  }
};