"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRoutingValueSuggestions = exports.useEnrichmentValueSuggestions = void 0;
var _react = require("react");
var _selectors = require("../components/data_management/stream_detail_enrichment/state_management/simulation_state_machine/selectors");
var _stream_enrichment_state_machine = require("../components/data_management/stream_detail_enrichment/state_management/stream_enrichment_state_machine");
var _stream_routing_state_machine = require("../components/data_management/stream_detail_routing/state_management/stream_routing_state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_RECORDS_STORED = 1000;

/**
 * Create field suggestions from accumulated simulation records
 * @param previewRecords array of flattened records
 * @param field field name to extract unique values for
 * @returns array of unique values for the specified field
 */
const createValueSuggestions = (previewRecords = [], field) => {
  if (!field) {
    return [];
  }
  const suggestions = new Set();
  previewRecords.forEach(record => {
    const value = record[field];
    if (value !== undefined) {
      suggestions.add(value);
    }
  });
  return Array.from(suggestions).sort().map(value => ({
    name: String(value)
  }));
};
const useValueSuggestions = (previewRecords, field) => {
  const [records, setRecords] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    setRecords(prevRecords => {
      const combined = [...previewRecords, ...prevRecords];
      return combined.slice(0, MAX_RECORDS_STORED);
    });
  }, [previewRecords]);
  return (0, _react.useMemo)(() => {
    return createValueSuggestions(records, field);
  }, [records, field]);
};

/**
 * Hook for providing value suggestions from enrichment simulation data - to be used with Enrichment only
 * @param field field name to extract unique values for
 * @returns array of unique suggestions for the specified field
 */
const useEnrichmentValueSuggestions = field => {
  return useValueSuggestions((0, _stream_enrichment_state_machine.useSimulatorSelector)(state => (0, _selectors.selectPreviewRecords)(state.context)), field);
};

/**
 * Hook for providing value suggestions from routing samples data - to be used with Routing only
 * @param field field name to extract unique values for
 * @returns array of unique suggestions for the specified field
 */
exports.useEnrichmentValueSuggestions = useEnrichmentValueSuggestions;
const useRoutingValueSuggestions = field => {
  return useValueSuggestions((0, _stream_routing_state_machine.useStreamSamplesSelector)(snapshot => (0, _stream_routing_state_machine.selectPreviewDocuments)(snapshot.context)), field);
};
exports.useRoutingValueSuggestions = useRoutingValueSuggestions;