"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateFailureStore = useUpdateFailureStore;
var _react = require("react");
var _reactHooks = require("@kbn/react-hooks");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUpdateFailureStore(definition) {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    signal
  } = (0, _reactHooks.useAbortController)();
  const updateFailureStore = (0, _react.useCallback)(async (name, failureStore) => {
    const data = await streamsRepositoryClient.fetch('PUT /api/streams/{name}/_ingest 2023-10-31', {
      params: {
        path: {
          name
        },
        body: {
          ingest: {
            ...definition.ingest,
            failure_store: failureStore
          }
        }
      },
      signal
    });
    return data;
  }, [streamsRepositoryClient, definition.ingest, signal]);
  return {
    updateFailureStore
  };
}