"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStreamsPrivileges = useStreamsPrivileges;
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _common = require("@kbn/streams-plugin/common");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStreamsPrivileges() {
  const {
    core: {
      pricing,
      application: {
        capabilities: {
          streams
        }
      },
      uiSettings
    },
    dependencies: {
      start: {
        licensing
      }
    }
  } = (0, _use_kibana.useKibana)();
  const license = (0, _useObservable.default)(licensing.license$);
  const groupStreamsEnabled = uiSettings.get(_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_GROUP_STREAMS, false);
  const significantEventsEnabled = uiSettings.get(_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_SIGNIFICANT_EVENTS, false // Default to false if the setting is not defined or not available
  );
  const significantEventsAvailableForTier = pricing.isFeatureAvailable(_common.STREAMS_TIERED_SIGNIFICANT_EVENT_FEATURE.id);
  const contentPacksEnabled = uiSettings.get(_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_CONTENT_PACKS, false);
  const attachmentsEnabled = uiSettings.get(_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_ATTACHMENTS, false);
  return {
    ui: streams,
    features: {
      ui: {
        enabled: true
      },
      significantEvents: license && {
        enabled: significantEventsEnabled,
        available: significantEventsEnabled && license.hasAtLeast('enterprise') && significantEventsAvailableForTier
      },
      groupStreams: {
        enabled: groupStreamsEnabled
      },
      contentPacks: {
        enabled: contentPacksEnabled
      },
      attachments: {
        enabled: attachmentsEnabled
      }
    },
    isLoading: !license
  };
}