"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStreamDocCountsFetch = useStreamDocCountsFetch;
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _react = require("react");
var _use_kibana = require("./use_kibana");
var _use_timefilter = require("./use_timefilter");
var _use_execute_esql_query = require("./use_execute_esql_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_NUM_DATA_POINTS = 25;
function useStreamDocCountsFetch({
  groupTotalCountByTimestamp,
  numDataPoints = DEFAULT_NUM_DATA_POINTS,
  canReadFailureStore
}) {
  const {
    timeState,
    timeState$
  } = (0, _use_timefilter.useTimefilter)();
  const {
    dependencies: {
      start: {
        data
      }
    }
  } = (0, _use_kibana.useKibana)();
  const promiseCache = (0, _react.useRef)({});
  const abortControllerRef = (0, _react.useRef)();
  if (!abortControllerRef.current) {
    abortControllerRef.current = new AbortController();
  }
  (0, _useUpdateEffect.default)(() => {
    var _abortControllerRef$c;
    promiseCache.current = {};
    (_abortControllerRef$c = abortControllerRef.current) === null || _abortControllerRef$c === void 0 ? void 0 : _abortControllerRef$c.abort();
    abortControllerRef.current = new AbortController();
  }, [canReadFailureStore]);
  (0, _react.useEffect)(() => {
    return () => {
      var _abortControllerRef$c2;
      (_abortControllerRef$c2 = abortControllerRef.current) === null || _abortControllerRef$c2 === void 0 ? void 0 : _abortControllerRef$c2.abort();
    };
  }, []);
  (0, _react.useEffect)(() => {
    const subscription = timeState$.subscribe({
      next: ({
        kind
      }) => {
        const shouldRefresh = kind !== 'initial';
        if (shouldRefresh) {
          var _abortControllerRef$c3;
          promiseCache.current = {};
          (_abortControllerRef$c3 = abortControllerRef.current) === null || _abortControllerRef$c3 === void 0 ? void 0 : _abortControllerRef$c3.abort();
          abortControllerRef.current = new AbortController();
        }
      }
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [timeState$]);
  return {
    getStreamDocCounts(streamName) {
      if (promiseCache.current[streamName]) {
        return promiseCache.current[streamName];
      }
      const abortController = abortControllerRef.current;
      if (!abortController) {
        throw new Error('Abort controller not set');
      }
      const minInterval = Math.floor((timeState.end - timeState.start) / numDataPoints);
      const source = canReadFailureStore ? `${streamName},${streamName}::failures` : streamName;
      const countPromise = (0, _use_execute_esql_query.executeEsqlQuery)({
        query: `FROM ${source} | STATS doc_count = COUNT(*)${groupTotalCountByTimestamp ? ` BY @timestamp = BUCKET(@timestamp, ${minInterval} ms)` : ''}`,
        search: data.search.search,
        signal: abortController.signal,
        start: timeState.start,
        end: timeState.end
      });
      const failedCountPromise = canReadFailureStore ? (0, _use_execute_esql_query.executeEsqlQuery)({
        query: `FROM ${streamName}::failures | STATS failed_doc_count = count(*)`,
        search: data.search.search,
        signal: abortController.signal,
        start: timeState.start,
        end: timeState.end
      }) : Promise.reject(new Error('Cannot read failed doc count, insufficient privileges'));
      const degradedCountPromise = (0, _use_execute_esql_query.executeEsqlQuery)({
        query: `FROM ${streamName} METADATA _ignored | WHERE _ignored IS NOT NULL | STATS degraded_doc_count = count(*)`,
        search: data.search.search,
        signal: abortController.signal,
        start: timeState.start,
        end: timeState.end
      });
      const histogramFetch = {
        docCount: countPromise,
        failedDocCount: failedCountPromise,
        degradedDocCount: degradedCountPromise
      };
      promiseCache.current[streamName] = histogramFetch;
      return histogramFetch;
    }
  };
}