"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailContextProvider = StreamDetailContextProvider;
exports.useStreamDetail = useStreamDetail;
exports.useStreamDetailAsIngestStream = useStreamDetailAsIngestStream;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _streamsSchema = require("@kbn/streams-schema");
var _public = require("@kbn/streams-plugin/public");
var _use_streams_app_fetch = require("./use_streams_app_fetch");
var _use_streams_app_breadcrumbs = require("./use_streams_app_breadcrumbs");
var _use_streams_app_params = require("./use_streams_app_params");
var _use_kibana = require("./use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/hooks/use_stream_detail.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StreamDetailContext = /*#__PURE__*/_react.default.createContext(undefined);
function StreamDetailContextProvider({
  name,
  streamsRepositoryClient,
  children
}) {
  const {
    core: {
      application: {
        capabilities: {
          streams: {
            [_public.STREAMS_UI_PRIVILEGES.manage]: canManage
          }
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    value: definition,
    loading,
    refresh
  } = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => {
    return streamsRepositoryClient.fetch('GET /api/streams/{name} 2023-10-31', {
      signal,
      params: {
        path: {
          name
        }
      }
    }).then(response => {
      if (_streamsSchema.Streams.ingest.all.GetResponse.is(response)) {
        return {
          ...response,
          privileges: {
            ...response.privileges,
            // restrict the manage privilege by the Elasticsearch-level data-stream specific privilege and the Kibana-level UI privilege
            // the UI should only enable manage features if the user has privileges on both levels for the current stream
            manage: response.privileges.manage && canManage
          }
        };
      }
      if (_streamsSchema.Streams.GroupStream.GetResponse.is(response)) {
        return response;
      }
      throw new Error('Stream detail only supports Ingest streams and Group streams.');
    });
  }, [streamsRepositoryClient, name, canManage]);
  const {
    path: {
      key
    }
  } = (0, _use_streams_app_params.useStreamsAppParams)('/{key}', true);
  (0, _use_streams_app_breadcrumbs.useStreamsAppBreadcrumbs)(() => {
    if (!definition || !_streamsSchema.Streams.WiredStream.Definition.is(definition.stream)) {
      return [{
        title: key,
        path: `/{key}`,
        params: {
          path: {
            key
          }
        }
      }];
    }
    // Build breadcrumbs for each segment in the hierarchy for wired streams
    const ids = (0, _streamsSchema.getAncestorsAndSelf)(key);
    const segments = (0, _streamsSchema.getSegments)(key);
    return ids.map((id, idx) => ({
      title: segments[idx],
      path: `/{key}`,
      params: {
        path: {
          key: id
        }
      }
    }));
  }, [key, definition]);
  const context = _react.default.useMemo(
  // useMemo cannot be used conditionally after the definition narrowing, the assertion is to narrow correctly the context value
  () => ({
    definition,
    loading,
    refresh
  }), [definition, loading, refresh]);

  // Display loading spinner for first data-fetching only to have SWR-like behaviour
  if (!definition && loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }));
  }
  if (!definition) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(StreamDetailContext.Provider, {
    value: context,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 10
    }
  }, children);
}
function useStreamDetail() {
  const ctx = _react.default.useContext(StreamDetailContext);
  if (!ctx) {
    throw new Error('useStreamDetail must be used within a StreamDetailContextProvider');
  }
  return ctx;
}
function useStreamDetailAsIngestStream() {
  const ctx = useStreamDetail();
  if (!_streamsSchema.Streams.WiredStream.GetResponse.is(ctx.definition) && !_streamsSchema.Streams.ClassicStream.GetResponse.is(ctx.definition)) {
    throw new Error('useStreamDetailAsIngestStream can only be used with IngestStreams');
  }
  return ctx;
}