"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeEsqlQuery = executeEsqlQuery;
var _esqlUtils = require("@kbn/esql-utils");
var _public = require("@kbn/streams-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Executes an ES|QL query using the data plugin's search service.
 * This replaces the previous /internal/streams/esql route by executing queries client-side.
 *
 * @param params - Query execution parameters
 * @returns Promise resolving to the ES|QL search response
 */
async function executeEsqlQuery({
  query,
  search,
  signal,
  filter,
  kuery,
  start,
  end
}) {
  const combinedFilter = (0, _public.buildEsqlFilter)({
    filter,
    kuery,
    start,
    end
  });
  const {
    response
  } = await (0, _esqlUtils.getESQLResults)({
    esqlQuery: query,
    search,
    signal,
    filter: combinedFilter,
    timeRange: start !== undefined && end !== undefined ? {
      from: new Date(start).toISOString(),
      to: new Date(end).toISOString(),
      mode: 'absolute'
    } : undefined
  });
  return response;
}