"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardsFetch = void 0;
var _use_kibana = require("./use_kibana");
var _use_streams_app_fetch = require("./use_streams_app_fetch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDashboardsFetch = name => {
  const {
    services: {
      telemetryClient
    },
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const dashboardsFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => {
    const response = await streamsRepositoryClient.fetch('GET /api/streams/{name}/dashboards 2023-10-31', {
      signal,
      params: {
        path: {
          name
        }
      }
    });
    telemetryClient.trackAttachmentCounts({
      name,
      dashboards: response.dashboards.length
    });
    return response;
  }, [name, streamsRepositoryClient, telemetryClient]);
  return dashboardsFetch;
};
exports.useDashboardsFetch = useDashboardsFetch;