"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverFlyoutStreamProcessingLink = DiscoverFlyoutStreamProcessingLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _common = require("../../common/url_schema/common");
var _use_resolved_definition_name = require("./use_resolved_definition_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/discover_features/discover_flyout_stream_processing_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DiscoverFlyoutStreamProcessingLink({
  doc,
  locator,
  streamsRepositoryClient
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    value,
    loading,
    error
  } = (0, _use_resolved_definition_name.useResolvedDefinitionName)({
    streamsRepositoryClient,
    doc
  });
  if (loading) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 23
    }
  });
  if (!value || error) return null;
  const href = locator.getRedirectUrl({
    name: value,
    managementTab: 'processing',
    pageState: {
      v: 1,
      dataSources: [getTargetDataSource(doc, value)]
    }
  });
  const message = _i18n.i18n.translate('xpack.streams.discoverFlyoutStreamProcessingLink', {
    defaultMessage: 'Parse content in Streams'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: message,
    display: "block",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sparkles",
    size: "s",
    css: (0, _react2.css)`
              margin-left: ${euiTheme.size.s};
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: "eui-textTruncate",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, message))));
}
const getTargetDataSource = (doc, streamName) => {
  const baseDataSource = {
    enabled: true,
    name: _i18n.i18n.translate('xpack.streams.discoverFlyoutStreamProcessingLink.customSamplesName', {
      defaultMessage: 'Discover document from {streamName}',
      values: {
        streamName
      }
    })
  };
  if (doc.raw._id) {
    return {
      ...baseDataSource,
      type: 'kql-samples',
      query: {
        language: 'kuery',
        query: `_id: ${doc.raw._id}`
      }
    };
  }
  return {
    ...baseDataSource,
    type: 'custom-samples',
    documents: [doc.flattened],
    storageKey: `${_common.CUSTOM_SAMPLES_DATA_SOURCE_STORAGE_KEY_PREFIX}${streamName}__discover-document`
  };
};